/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.compat.Curios;
import io.redspace.ironsspellbooks.config.ClientConfigs;
import io.redspace.ironsspellbooks.gui.overlays.ManaBarOverlay;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.player.ClientRenderCache;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class SpellBarOverlay
extends GuiComponent {
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");
    static final int IMAGE_HEIGHT = 21;
    static final int IMAGE_WIDTH = 21;
    static final int HOTBAR_HALFWIDTH = 91;
    static final int boxSize = 20;
    static int screenHeight;
    static int screenWidth;
    static final int CONTEXTUAL_FADE_WAIT = 80;
    static int fadeoutDelay;
    static int lastTick;
    static float alpha;
    static SpellSelectionManager lastSelection;

    public static void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        int i;
        int centerY;
        int centerX;
        SpellSelectionManager ssm;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ManaBarOverlay.Display displayMode = (ManaBarOverlay.Display)((Object)ClientConfigs.SPELL_BAR_DISPLAY.get());
        if (displayMode == ManaBarOverlay.Display.Never || player == null) {
            return;
        }
        if (displayMode == ManaBarOverlay.Display.Contextual) {
            SpellBarOverlay.handleFading((Player)player);
            if (fadeoutDelay <= 0) {
                return;
            }
        } else {
            alpha = 1.0f;
        }
        if ((ssm = ClientMagicData.getSpellSelectionManager()) != lastSelection) {
            lastSelection = ssm;
            ClientRenderCache.generateRelativeLocations(ssm, 20, 22);
            if (displayMode == ManaBarOverlay.Display.Contextual) {
                fadeoutDelay = 80;
            }
        }
        if (ssm.getSpellCount() <= 0) {
            return;
        }
        int configOffsetY = (Integer)ClientConfigs.SPELL_BAR_Y_OFFSET.get();
        int configOffsetX = (Integer)ClientConfigs.SPELL_BAR_X_OFFSET.get();
        Anchor anchor = (Anchor)((Object)ClientConfigs.SPELL_BAR_ANCHOR.get());
        if (anchor == Anchor.Hotbar) {
            centerX = screenWidth / 2 - Math.max(110, screenWidth / 4);
            centerY = screenHeight - Math.max(55, screenHeight / 8);
        } else {
            centerX = screenWidth * anchor.m1;
            centerY = screenHeight * anchor.m2;
        }
        centerX += configOffsetX;
        centerY += configOffsetY;
        List<SpellData> spells = ssm.getAllSpells().stream().map(slot -> slot.spellData).toList();
        int spellbookCount = ssm.getSpellsForSlot(Curios.SPELLBOOK_SLOT).size();
        List<Vec2> locations = ClientRenderCache.relativeSpellBarSlotLocations;
        int approximateWidth = locations.size() / 3;
        centerX -= approximateWidth * 5;
        int selectedSpellIndex = ssm.getGlobalSelectionIndex();
        SpellBarOverlay.setTranslucentTexture(TEXTURE);
        for (Vec2 location : locations) {
            gui.m_93228_(poseStack, centerX + (int)location.f_82470_, centerY + (int)location.f_82471_, 66, 84, 22, 22);
        }
        for (i = 0; i < locations.size(); ++i) {
            SpellBarOverlay.setOpaqueTexture(spells.get(i).getSpell().getSpellIconResource());
            ForgeGui.m_93133_((PoseStack)poseStack, (int)(centerX + (int)locations.get((int)i).f_82470_ + 3), (int)(centerY + (int)locations.get((int)i).f_82471_ + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        for (i = 0; i < locations.size(); ++i) {
            float f;
            SpellBarOverlay.setTranslucentTexture(TEXTURE);
            if (i != selectedSpellIndex) {
                gui.m_93228_(poseStack, centerX + (int)locations.get((int)i).f_82470_, centerY + (int)locations.get((int)i).f_82471_, 22 + (!ssm.getAllSpells().get((int)i).slot.equals(Curios.SPELLBOOK_SLOT) ? 110 : 0), 84, 22, 22);
            }
            if (!((f = ClientMagicData.getCooldownPercent(spells.get(i).getSpell())) > 0.0f)) continue;
            int pixels = (int)(16.0f * f + 1.0f);
            gui.m_93228_(poseStack, centerX + (int)locations.get((int)i).f_82470_ + 3, centerY + (int)locations.get((int)i).f_82471_ + 19 - pixels, 47, 87, 16, pixels);
        }
        for (i = 0; i < locations.size(); ++i) {
            SpellBarOverlay.setTranslucentTexture(TEXTURE);
            if (i != selectedSpellIndex) continue;
            gui.m_93228_(poseStack, centerX + (int)locations.get((int)i).f_82470_, centerY + (int)locations.get((int)i).f_82471_, 0, 84, 22, 22);
        }
    }

    private static void handleFading(Player player) {
        if (lastTick != player.f_19797_) {
            lastTick = player.f_19797_;
            if (ClientMagicData.isCasting() || ClientMagicData.getCooldowns().hasCooldownsActive() || ClientMagicData.getRecasts().hasRecastsActive()) {
                fadeoutDelay = 80;
            }
            if (fadeoutDelay > 0) {
                --fadeoutDelay;
            }
        }
        alpha = Mth.m_14036_((float)((float)fadeoutDelay / 20.0f), (float)0.0f, (float)1.0f);
        if (fadeoutDelay <= 0) {
            return;
        }
    }

    private static void setOpaqueTexture(ResourceLocation texture) {
        if (alpha != 1.0f) {
            SpellBarOverlay.setTranslucentTexture(texture);
        } else {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        }
    }

    private static void setTranslucentTexture(ResourceLocation texture) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172649_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static enum Anchor {
        Hotbar(0, 0),
        TopLeft(0, 0),
        TopRight(0, 1),
        BottomLeft(0, 1),
        BottomRight(1, 1);

        final int m1;
        final int m2;

        private Anchor(int mx, int my) {
            this.m1 = mx;
            this.m2 = my;
        }
    }
}

