/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.magic_missile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.fireball.FireballRenderer;
import io.redspace.ironsspellbooks.entity.spells.magic_missile.MagicMissileProjectile;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class MagicMissileRenderer
extends EntityRenderer<MagicMissileProjectile> {
    private static final ResourceLocation TEXTURE = IronsSpellbooks.id("textures/entity/magic_missile/magic_missile.png");
    private static final ResourceLocation[] FIRE_TEXTURES = new ResourceLocation[]{IronsSpellbooks.id("textures/entity/magic_missile/fire_1.png"), IronsSpellbooks.id("textures/entity/magic_missile/fire_2.png"), IronsSpellbooks.id("textures/entity/magic_missile/fire_3.png"), IronsSpellbooks.id("textures/entity/magic_missile/fire_4.png")};
    private final ModelPart body;
    protected final ModelPart outline;

    public MagicMissileRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(FireballRenderer.MODEL_LAYER_LOCATION);
        this.body = modelpart.m_171324_("body");
        this.outline = modelpart.m_171324_("outline");
    }

    public void render(MagicMissileProjectile entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        Vec3 motion = entity.m_20184_();
        float xRot = -((float)(Mth.m_14136_((double)motion.m_165924_(), (double)motion.f_82480_) * 57.2957763671875) - 90.0f);
        float yRot = -((float)(Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_) * 57.2957763671875) + 90.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        poseStack.m_85841_(0.35f, 0.35f, 0.45f);
        VertexConsumer consumer = bufferSource.m_6299_(this.renderType(this.getTextureLocation(entity)));
        this.body.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, 0.8f, 0.8f, 0.8f, 1.0f);
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        poseStack.m_85837_(0.0, 0.0, (double)0.4f);
        consumer = bufferSource.m_6299_(this.renderType(this.getFireTextureLocation(entity)));
        this.outline.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, 0.8f, 0.8f, 0.8f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public RenderType renderType(ResourceLocation TEXTURE) {
        return RenderType.m_110436_((ResourceLocation)TEXTURE, (float)0.0f, (float)0.0f);
    }

    public ResourceLocation getTextureLocation(MagicMissileProjectile entity) {
        return TEXTURE;
    }

    public ResourceLocation getFireTextureLocation(Projectile entity) {
        int frame = entity.f_19797_ % FIRE_TEXTURES.length;
        return FIRE_TEXTURES[frame];
    }
}

