/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class BloodCauldronBlock
extends LayeredCauldronBlock {
    public static final Predicate<Biome.Precipitation> NO_WEATHER = p_153526_ -> false;

    public BloodCauldronBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_), NO_WEATHER, BloodCauldronBlock.getInteractionMap());
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (entity.f_19797_ % 20 == 0) {
            BloodCauldronBlock.attemptCookEntity(blockState, level, pos, entity, () -> {
                level.m_46597_(pos, (BlockState)blockState.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                level.m_142346_(null, GameEvent.f_157769_, pos);
            });
        }
        super.m_7892_(blockState, level, pos, entity);
    }

    public static void attemptCookEntity(BlockState blockState, Level level, BlockPos pos, Entity entity, CookExecution execution) {
        Block block;
        if (!level.f_46443_ && CampfireBlock.m_51319_((BlockState)level.m_8055_(pos.m_7495_())) && (block = level.m_8055_(pos).m_60734_()) instanceof AbstractCauldronBlock) {
            LivingEntity livingEntity;
            AbstractCauldronBlock cauldron = (AbstractCauldronBlock)block;
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_20191_().m_82381_(cauldron.m_6079_(blockState, (BlockGetter)level, pos).m_83215_().m_82338_(pos)) && livingEntity.m_6469_(DamageSources.CAULDRON, 2.0f)) {
                MagicManager.spawnParticles(level, ParticleHelper.BLOOD, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 20, 0.05, 0.05, 0.05, 0.1, false);
                if (Utils.random.m_188500_() <= 0.5 && !BloodCauldronBlock.isCauldronFull(blockState)) {
                    execution.execute();
                }
            }
        }
    }

    private static boolean isCauldronFull(BlockState blockState) {
        if (!blockState.m_61138_((Property)f_153514_)) {
            return false;
        }
        return (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3;
    }

    public static Map<Item, CauldronInteraction> getInteractionMap() {
        Object2ObjectOpenHashMap BLOOD_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
        BLOOD_CAULDRON_INTERACTIONS.put(Items.f_42590_, (blockState, level, blockPos, player, hand, itemStack) -> {
            if (!level.f_46443_) {
                Item item = itemStack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)ItemRegistry.BLOOD_VIAL.get())));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                level.m_5594_(null, blockPos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157816_, blockPos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        return BLOOD_CAULDRON_INTERACTIONS;
    }

    public static interface CookExecution {
        public void execute();
    }
}

