/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.capability;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.nameless.indestructible.api.animation.types.CommandEvent;
import com.nameless.indestructible.api.animation.types.CustomGuardAnimation;
import com.nameless.indestructible.client.gui.BossBarGUi;
import com.nameless.indestructible.data.AdvancedMobpatchReloader;
import com.nameless.indestructible.gameasset.GuardAnimations;
import com.nameless.indestructible.server.AdvancedBossInfo;
import com.nameless.indestructible.world.ai.goal.AdvancedChasingGoal;
import com.nameless.indestructible.world.ai.goal.AdvancedCombatGoal;
import com.nameless.indestructible.world.ai.goal.GuardGoal;
import com.nameless.indestructible.world.ai.task.AdvancedChasingBehavior;
import com.nameless.indestructible.world.ai.task.AdvancedCombatBehavior;
import com.nameless.indestructible.world.ai.task.GuardBehavior;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPSpawnData;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.SourceTag;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedCustomHumanoidMobPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    private final AdvancedMobpatchReloader.AdvancedCustomHumanoidMobPatchProvider provider;
    private final Map<WeaponCategory, Map<Style, GuardMotion>> weaponGuardMotions;
    private static final EntityDataAccessor<Float> STAMINA = new EntityDataAccessor(253, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ATTACK_SPEED = new EntityDataAccessor(177, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_BLOCKING = new EntityDataAccessor(178, EntityDataSerializers.f_135035_);
    public static final ResourceLocation BOSS_BAR = new ResourceLocation("indestructible", "textures/gui/boss_bar.png");
    private final int regenStaminaStandbyTime;
    private final boolean hasStunReduction;
    private final float maxStunShield;
    private final int reganShieldStandbyTime;
    private final float reganShieldMultiply;
    private final float staminaLoseMultiply;
    private int block_tick;
    private boolean cancel_block;
    private int maxParryTimes;
    private int tickSinceLastAction;
    private int tickSinceBreakShield;
    private CounterMotion counterMotion;
    private boolean isParry;
    private int parryCounter = 0;
    private int parryTimes = 0;
    private int stun_immunity_time;
    private final float guardRadius;
    private final float attackRadius;
    private DamageSourceModifier damageSourceModifier = null;
    private final List<CommandEvent.TimeStampedEvent> timeEvents = Lists.newArrayList();
    private final List<CommandEvent.HitEvent> hitEvents = Lists.newArrayList();
    private final List<CommandEvent.StunEvent> stunEvents = Lists.newArrayList();
    private int phase;
    private int hurtResistLevel = 2;
    private boolean neutralized;
    private float strafingForward;
    private float strafingClockwise;
    private int strafingTime;
    private int inactionTime;
    private int convertTick = 0;
    private boolean isRunning = false;
    private Entity lastAttacker;
    private float lastGetImpact;
    private GuardMotion specificGuardMotion;
    private AdvancedBossInfo bossInfo;
    public boolean hasBossBar;
    private Component customName;
    private ResourceLocation bossBar;

    public AdvancedCustomHumanoidMobPatch(Faction faction, AdvancedMobpatchReloader.AdvancedCustomHumanoidMobPatchProvider provider) {
        super(faction);
        this.provider = provider;
        this.regenStaminaStandbyTime = this.provider.getRegenStaminaStandbyTime();
        this.hasStunReduction = this.provider.hasStunReduction();
        this.maxStunShield = this.provider.getMaxStunShield();
        this.reganShieldStandbyTime = this.provider.getReganShieldStandbyTime();
        this.reganShieldMultiply = this.provider.getReganShieldMultiply();
        this.staminaLoseMultiply = this.provider.getStaminaLoseMultiply();
        this.weaponLivingMotions = this.provider.getHumanoidWeaponMotions();
        this.weaponAttackMotions = this.provider.getHumanoidCombatBehaviors();
        this.weaponGuardMotions = this.provider.getGuardMotions();
        this.guardRadius = this.provider.getGuardRadius();
        this.attackRadius = this.provider.getAttackRadius();
        this.hasBossBar = this.provider.hasBossBar();
    }

    public void onConstructed(T entityIn) {
        super.onConstructed(entityIn);
        entityIn.m_20088_().m_135372_(STAMINA, (Object)Float.valueOf(0.0f));
        entityIn.m_20088_().m_135372_(ATTACK_SPEED, (Object)Float.valueOf(1.0f));
        entityIn.m_20088_().m_135372_(IS_BLOCKING, (Object)false);
        if (this.hasBossBar) {
            this.bossInfo = new AdvancedBossInfo(this);
        }
    }

    public void onJoinWorld(T entityIn, EntityJoinLevelEvent event) {
        this.initialized = true;
        ((PathfinderMob)this.original).m_21204_().f_22141_ = new AttributeSupplier(this.putEpicFightAttributes(((PathfinderMob)this.original).m_21204_().f_22141_.f_22241_));
        this.initAttributes();
        if (!((PathfinderMob)entityIn).f_19853_.m_5776_() && !((PathfinderMob)this.original).m_21525_()) {
            this.initAI();
        }
        this.tickSinceLastAction = 0;
        this.tickSinceBreakShield = 0;
        this.block_tick = 30;
        this.setStamina(this.getMaxStamina());
        this.setAttackSpeed(1.0f);
        this.setPhase(0);
        if (this.maxStunShield > 0.0f) {
            this.setMaxStunShield(this.maxStunShield);
            this.setStunShield(this.maxStunShield);
        }
        if (!this.isLogicalClient()) {
            this.initStunEvent(this.provider);
            this.resetMotion();
        }
        this.bossBar = this.provider.getBossBar() == null ? BOSS_BAR : this.provider.getBossBar();
        this.customName = this.provider.getName() == null ? ((PathfinderMob)this.getOriginal()).m_6095_().m_20676_() : Component.m_237115_((String)this.provider.getName());
    }

    private Map<Attribute, AttributeInstance> putEpicFightAttributes(Map<Attribute, AttributeInstance> originalMap) {
        HashMap newMap = Maps.newHashMap();
        AttributeSupplier supplier = AttributeSupplier.m_22244_().m_22266_(Attributes.f_22281_).m_22266_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22266_((Attribute)EpicFightAttributes.IMPACT.get()).m_22266_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22266_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22266_((Attribute)EpicFightAttributes.STUN_ARMOR.get()).m_22266_((Attribute)EpicFightAttributes.MAX_EXECUTION_RESISTANCE.get()).m_22266_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()).m_22266_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get()).m_22266_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()).m_22266_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()).m_22266_((Attribute)EpicFightAttributes.MAX_STAMINA.get()).m_22266_((Attribute)EpicFightAttributes.STAMINA_REGEN.get()).m_22265_();
        newMap.putAll(supplier.f_22241_);
        newMap.putAll(originalMap);
        return ImmutableMap.copyOf((Map)newMap);
    }

    public void serverTick(LivingEvent.LivingTickEvent event) {
        if (this.hasBossBar && ((PathfinderMob)this.getOriginal()).f_19797_ % 4 == 0) {
            this.bossInfo.update();
        }
        if (this.hasStunReduction) {
            super.serverTick(event);
        }
        if (!this.state.inaction() && this.isBlocking()) {
            ++this.tickSinceLastAction;
        }
        float stamina = this.getStamina();
        float maxStamina = this.getMaxStamina();
        float staminaRegen = (float)((PathfinderMob)this.original).m_21133_((Attribute)EpicFightAttributes.STAMINA_REGEN.get());
        if (stamina < maxStamina) {
            if (this.tickSinceLastAction > this.regenStaminaStandbyTime) {
                float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
                this.setStamina(stamina + maxStamina * (0.01f * staminaRegen) * staminaFactor);
            } else {
                this.setStamina(stamina + 0.0015f * staminaRegen * maxStamina);
            }
        }
        if (maxStamina < stamina) {
            this.setStamina(maxStamina);
        }
        if (this.maxStunShield > 0.0f) {
            float stunShield = this.getStunShield();
            float maxStunShield = this.getMaxStunShield();
            if (stunShield > 0.0f) {
                if (stunShield < maxStunShield && !this.getEntityState().hurt() && !this.getEntityState().knockDown()) {
                    this.setStunShield(stunShield + 0.0015f * this.reganShieldMultiply * maxStunShield);
                }
                if (this.tickSinceBreakShield > 0) {
                    this.tickSinceBreakShield = 0;
                }
            }
            if (stunShield == 0.0f) {
                ++this.tickSinceBreakShield;
                if (this.tickSinceBreakShield > this.reganShieldStandbyTime) {
                    this.setStunShield(this.getMaxStunShield());
                }
            }
            if (stunShield > maxStunShield) {
                this.setStunShield(this.getMaxStunShield());
            }
        }
        if (this.neutralized && this.getEntityState().hurtLevel() < 2) {
            this.neutralized = false;
        }
    }

    protected void clientTick(LivingEvent.LivingTickEvent event) {
        boolean shouldRunning;
        boolean bl = shouldRunning = ((PathfinderMob)this.original).f_20924_ >= 0.7f;
        if (shouldRunning != this.isRunning) {
            ++this.convertTick;
            if (this.convertTick > 4) {
                this.isRunning = shouldRunning;
            }
        } else {
            this.convertTick = 0;
        }
    }

    public boolean hasTimeEvent() {
        return !this.timeEvents.isEmpty();
    }

    public List<CommandEvent.TimeStampedEvent> getTimeEventList() {
        return this.timeEvents;
    }

    public void addEvent(CommandEvent.TimeStampedEvent event) {
        this.timeEvents.add(event);
    }

    public boolean hasHitEvent() {
        return !this.hitEvents.isEmpty();
    }

    public List<CommandEvent.HitEvent> getHitEventList() {
        return this.hitEvents;
    }

    public void addEvent(CommandEvent.HitEvent event) {
        this.hitEvents.add(event);
    }

    private void initStunEvent(AdvancedMobpatchReloader.AdvancedCustomHumanoidMobPatchProvider provider) {
        this.stunEvents.clear();
        if (provider.getStunEvent() != null && !provider.getStunEvent().isEmpty()) {
            this.stunEvents.addAll(this.provider.getStunEvent());
        }
    }

    public void resetMotion() {
        if (this.hasTimeEvent()) {
            this.timeEvents.clear();
        }
        if (this.hasHitEvent()) {
            this.hitEvents.clear();
        }
        if (this.damageSourceModifier != null) {
            this.damageSourceModifier = null;
        }
    }

    public void setBlockTick(int value) {
        this.block_tick = value;
    }

    public int getBlockTick() {
        return this.block_tick;
    }

    public void setBlocking(boolean blocking) {
        ((PathfinderMob)this.original).m_20088_().m_135381_(IS_BLOCKING, (Object)blocking);
    }

    public boolean isBlocking() {
        return (Boolean)((PathfinderMob)this.original).m_20088_().m_135370_(IS_BLOCKING);
    }

    public void cancelBlock(boolean setCancel) {
        this.cancel_block = setCancel;
    }

    public void setParry(boolean isParry) {
        this.isParry = isParry;
    }

    public float getMaxStamina() {
        AttributeInstance maxStamina = ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
        return (float)(maxStamina == null ? 0.0 : maxStamina.m_22135_());
    }

    public float getStamina() {
        return this.getMaxStamina() == 0.0f ? 0.0f : ((Float)((PathfinderMob)this.original).m_20088_().m_135370_(STAMINA)).floatValue();
    }

    public void setStamina(float value) {
        float f1 = Math.max(Math.min(value, this.getMaxStamina()), 0.0f);
        ((PathfinderMob)this.original).m_20088_().m_135381_(STAMINA, (Object)Float.valueOf(f1));
    }

    public float getAttackSpeed() {
        return ((Float)((PathfinderMob)this.original).m_20088_().m_135370_(ATTACK_SPEED)).floatValue();
    }

    public void setAttackSpeed(float value) {
        ((PathfinderMob)this.original).m_20088_().m_135381_(ATTACK_SPEED, (Object)Float.valueOf(Math.abs(value)));
    }

    public void setParryCounter(int counter) {
        this.parryCounter = counter;
    }

    public void setStunImmunityTime(int time) {
        this.stun_immunity_time = time;
    }

    public void setMaxParryTimes(int times) {
        this.maxParryTimes = times;
    }

    public void setCounterMotion(CounterMotion counter_motion) {
        this.counterMotion = counter_motion;
    }

    public StaticAnimation getCounter() {
        return this.counterMotion.counter;
    }

    public float getCounterChance() {
        return this.counterMotion.chance;
    }

    public float getCounterStamina() {
        return this.counterMotion.cost;
    }

    public float getCounterSpeed() {
        return this.counterMotion.speed;
    }

    public void specificGuardMotion(@Nullable GuardMotion specific_guard_motion) {
        this.specificGuardMotion = specific_guard_motion;
    }

    public void resetActionTick() {
        this.tickSinceLastAction = 0;
    }

    public int getTickSinceLastAction() {
        return this.tickSinceLastAction;
    }

    public void setDamageSourceModifier(DamageSourceModifier damageSourceModifier) {
        this.damageSourceModifier = damageSourceModifier;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = Math.min(Math.max(0, phase), 20);
    }

    public void setHurtResistLevel(int hurtResistLevel) {
        this.hurtResistLevel = Math.max(hurtResistLevel, 1);
    }

    public int getHurtResistLevel() {
        return this.hurtResistLevel;
    }

    public int getStrafingTime() {
        return this.strafingTime;
    }

    public void setStrafingTime(int time) {
        this.strafingTime = time;
    }

    public float getStrafingForward() {
        return this.strafingForward;
    }

    public float getStrafingClockwise() {
        return this.strafingClockwise;
    }

    public int getInactionTime() {
        return this.inactionTime;
    }

    public void setInactionTime(int time) {
        this.inactionTime = time;
    }

    public void setStrafingDirection(float forward, float clockwise) {
        this.strafingForward = forward;
        this.strafingClockwise = clockwise;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public ResourceLocation getBossBar() {
        return this.bossBar;
    }

    public void setAIAsInfantry(boolean holdingRangedWeapon) {
        CombatBehaviors.Builder builder;
        boolean isUsingBrain;
        boolean bl = isUsingBrain = !((PathfinderMob)this.getOriginal()).m_6274_().f_21845_.isEmpty();
        if (isUsingBrain) {
            if (!holdingRangedWeapon) {
                CombatBehaviors.Builder builder2 = this.getHoldingItemWeaponMotionBuilder();
                if (builder2 != null) {
                    BrainRecomposer.replaceBehaviors((Brain)((PathfinderMob)this.original).m_6274_(), (Activity)Activity.f_37988_, MeleeAttack.class, new AdvancedCombatBehavior<AdvancedCustomHumanoidMobPatch>(this, builder2.build((MobPatch)this)));
                    BrainRecomposer.replaceBehaviors((Brain)((PathfinderMob)this.original).m_6274_(), (Activity)Activity.f_37988_, RunIf.class, (Behavior)new RunIf(entity -> !entity.m_21093_(is -> is.m_41720_() instanceof ProjectileWeaponItem), new GuardBehavior(this, this.guardRadius)));
                }
                BrainRecomposer.replaceBehaviors((Brain)((PathfinderMob)this.original).m_6274_(), (Activity)Activity.f_37978_, MoveToTargetSink.class, new AdvancedChasingBehavior<AdvancedCustomHumanoidMobPatch>(this, this.provider.getChasingSpeed(), this.attackRadius));
            }
        } else if (!holdingRangedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AdvancedCombatGoal<AdvancedCustomHumanoidMobPatch>(this, builder.build((MobPatch)this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, (Goal)new GuardGoal(this, this.guardRadius));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, new AdvancedChasingGoal<AdvancedCustomHumanoidMobPatch>(this, (PathfinderMob)this.getOriginal(), this.provider.getChasingSpeed(), true, this.attackRadius));
        }
    }

    protected void setWeaponMotions() {
        if (this.weaponAttackMotions == null) {
            super.setWeaponMotions();
        }
    }

    protected void initAttributes() {
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.WEIGHT.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.MAX_STRIKES.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.ARMOR_NEGATION.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.IMPACT.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.MAX_STAMINA.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.STAMINA_REGEN.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.STAMINA_REGEN.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get()).m_22100_(0.5);
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()).m_22100_(0.0);
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()).m_22100_((double)1.2f);
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()).m_22100_(1.0);
        if (this.provider.getAttributeValues().containsKey(Attributes.f_22281_)) {
            ((PathfinderMob)this.original).m_21051_(Attributes.f_22281_).m_22100_(this.provider.getAttributeValues().get(Attributes.f_22281_).doubleValue());
        }
    }

    public void initAnimator(ClientAnimator clientAnimator) {
        for (Pair<LivingMotion, StaticAnimation> pair : this.provider.getDefaultAnimations()) {
            clientAnimator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
        }
        clientAnimator.setCurrentMotionsAsDefault();
    }

    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((PathfinderMob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((PathfinderMob)this.original).m_20202_() != null ? LivingMotions.MOUNT : (((PathfinderMob)this.original).m_20184_().f_82480_ < (double)-0.55f ? LivingMotions.FALL : (((PathfinderMob)this.original).f_20924_ > 0.01f ? (this.isRunning ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
        if (((PathfinderMob)this.original).m_6117_()) {
            CapabilityItem activeItem = this.getHoldingItemCapability(((PathfinderMob)this.original).m_7655_());
            UseAnim useAnim = ((PathfinderMob)this.original).m_21120_(((PathfinderMob)this.original).m_7655_()).m_41780_();
            UseAnim secondUseAnim = activeItem.getUseAnimation((LivingEntityPatch)this);
            this.currentCompositeMotion = useAnim == UseAnim.BLOCK || secondUseAnim == UseAnim.BLOCK ? (activeItem.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK) : (useAnim == UseAnim.BOW || useAnim == UseAnim.SPEAR ? LivingMotions.AIM : (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : this.currentLivingMotion));
        } else {
            this.currentCompositeMotion = this.isBlocking() ? LivingMotions.BLOCK : (CrossbowItem.m_40932_((ItemStack)((PathfinderMob)this.original).m_21205_()) ? LivingMotions.AIM : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation() ? LivingMotions.NONE : (((PathfinderMob)this.original).f_20911_ && ((PathfinderMob)this.original).m_21257_().isEmpty() ? LivingMotions.DIGGING : this.currentLivingMotion)));
            if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM) {
                this.playReboundAnimation();
            }
        }
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult result = super.attack(damageSource, target, hand);
        if (result.resultType.dealtDamage() && this.hasHitEvent()) {
            for (CommandEvent.HitEvent event : this.getHitEventList()) {
                event.testAndExecute((LivingEntityPatch<?>)this, target);
                if (((PathfinderMob)this.getOriginal()).m_6084_() && this.hasHitEvent()) continue;
                break;
            }
        }
        return result;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }

    public void setStunReductionOnHit(StunType stunType) {
        if (this.hasStunReduction) {
            super.setStunReductionOnHit(stunType);
        }
    }

    public float getStunReduction() {
        if (this.hasStunReduction) {
            return super.getStunReduction();
        }
        return 0.0f;
    }

    public void modifyLivingMotionByCurrentItem() {
        Map<Style, GuardMotion> motionByStyle;
        Style style;
        Map mapByStyle;
        this.getAnimator().resetLivingAnimations();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap motionModifier = Maps.newHashMap();
        motionModifier.putAll(offhandCap.getLivingMotionModifier((LivingEntityPatch)this, InteractionHand.OFF_HAND));
        motionModifier.putAll(mainhandCap.getLivingMotionModifier((LivingEntityPatch)this, InteractionHand.MAIN_HAND));
        for (Map.Entry entry : motionModifier.entrySet()) {
            this.getAnimator().addLivingAnimation((LivingMotion)entry.getKey(), (StaticAnimation)entry.getValue());
        }
        if (this.weaponLivingMotions != null && this.weaponLivingMotions.containsKey(mainhandCap.getWeaponCategory()) && ((mapByStyle = (Map)this.weaponLivingMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle((LivingEntityPatch)this)) || mapByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            Set animModifierSet = mapByStyle.getOrDefault(style, (Set)mapByStyle.get(CapabilityItem.Styles.COMMON));
            for (Pair pair : animModifierSet) {
                this.animator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
            }
        }
        if (this.weaponGuardMotions != null && this.weaponGuardMotions.containsKey(mainhandCap.getWeaponCategory()) && ((motionByStyle = this.weaponGuardMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle((LivingEntityPatch)this)) || motionByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            StaticAnimation guard = motionByStyle.getOrDefault((Object)style, (GuardMotion)motionByStyle.get((Object)CapabilityItem.Styles.COMMON)).guard_animation;
            this.animator.addLivingAnimation((LivingMotion)LivingMotions.BLOCK, guard);
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((PathfinderMob)this.original).m_19879_());
        msg.putEntries(this.getAnimator().getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original);
    }

    private GuardMotion getCurrentGuardMotion() {
        if (this.specificGuardMotion != null) {
            return this.specificGuardMotion;
        }
        CapabilityItem itemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (this.weaponGuardMotions != null && itemCap != null) {
            Style style = itemCap.getStyle((LivingEntityPatch)this);
            Map<Style, GuardMotion> mapByStyle = this.weaponGuardMotions.get(itemCap.getWeaponCategory());
            if (mapByStyle != null && (mapByStyle.containsKey(style) || mapByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
                return mapByStyle.getOrDefault(style, mapByStyle.get(CapabilityItem.Styles.COMMON));
            }
        }
        return new GuardMotion(GuardAnimations.MOB_LONGSWORD_GUARD, false, 1.0f);
    }

    public float getGuardCostMultiply() {
        return this.getCurrentGuardMotion().cost;
    }

    public CustomGuardAnimation getGuardAnimation() {
        StaticAnimation staticAnimation = this.getCurrentGuardMotion().guard_animation;
        if (staticAnimation instanceof CustomGuardAnimation) {
            CustomGuardAnimation guardAnimation = (CustomGuardAnimation)staticAnimation;
            return guardAnimation;
        }
        return (CustomGuardAnimation)GuardAnimations.MOB_LONGSWORD_GUARD;
    }

    public boolean canBlockProjectile() {
        return this.getCurrentGuardMotion().canBlockProjectile;
    }

    public float getParryCostMultiply() {
        return this.getCurrentGuardMotion().parry_cost;
    }

    public StaticAnimation getParryAnimation() {
        StaticAnimation[] staticAnimationArray;
        if (this.getCurrentGuardMotion().parry_animation != null) {
            staticAnimationArray = this.getCurrentGuardMotion().parry_animation;
        } else {
            StaticAnimation[] staticAnimationArray2 = new StaticAnimation[2];
            staticAnimationArray2[0] = Animations.LONGSWORD_GUARD_ACTIVE_HIT1;
            staticAnimationArray = staticAnimationArray2;
            staticAnimationArray2[1] = Animations.LONGSWORD_GUARD_ACTIVE_HIT2;
        }
        StaticAnimation[] parry_animation = staticAnimationArray;
        return parry_animation[this.parryTimes % parry_animation.length];
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        AttackResult result = AttackResult.of((AttackResult.ResultType)this.getEntityState().attackResult(damageSource), (float)amount);
        if (result.resultType.dealtDamage()) {
            AttackResult attackResult = result = damageSource.m_7640_() != this.getOriginal() ? this.tryProcess(damageSource, amount) : result;
            if (result.resultType.dealtDamage()) {
                this.lastAttacker = damageSource.m_7640_();
                if (damageSource instanceof EpicFightDamageSource) {
                    EpicFightDamageSource efDamageSource = (EpicFightDamageSource)damageSource;
                    this.lastGetImpact = efDamageSource.getImpact();
                } else {
                    this.lastGetImpact = amount / 3.0f;
                }
            }
        }
        return result;
    }

    private boolean canBlockSource(DamageSource damageSource) {
        return !damageSource.m_19372_() && !damageSource.m_19387_() && !damageSource.m_19378_() && (!damageSource.m_19360_() || this.canBlockProjectile());
    }

    private AttackResult tryProcess(DamageSource damageSource, float amount) {
        if (this.isBlocking()) {
            CustomGuardAnimation animation = this.getGuardAnimation();
            StaticAnimation success = animation.successAnimation != null ? EpicFightMod.getInstance().animationManager.findAnimationByPath(animation.successAnimation) : Animations.SWORD_GUARD_HIT;
            boolean isFront = false;
            Vec3 sourceLocation = damageSource.m_7270_();
            if (sourceLocation != null) {
                Vec3 viewVector = ((PathfinderMob)this.getOriginal()).m_20252_(1.0f);
                Vec3 toSourceLocation = sourceLocation.m_82546_(((PathfinderMob)this.getOriginal()).m_20182_()).m_82541_();
                if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                    isFront = true;
                }
            }
            if (this.canBlockSource(damageSource) && isFront) {
                float impact;
                if (damageSource instanceof EpicFightDamageSource) {
                    EpicFightDamageSource efDamageSource = (EpicFightDamageSource)damageSource;
                    impact = efDamageSource.getImpact();
                    if (efDamageSource.hasTag((SourceTag)SourceTags.GUARD_PUNCTURE) && efDamageSource.hasTag((SourceTag)SourceTags.GUARD_PUNCTURE)) {
                        return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
                    }
                } else {
                    impact = amount / 3.0f;
                }
                float knockback = 0.25f + Math.min(impact * 0.1f, 1.0f);
                Entity entity = damageSource.m_7640_();
                if (entity instanceof LivingEntity) {
                    LivingEntity targetEntity = (LivingEntity)entity;
                    knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)targetEntity) * 0.1f;
                }
                float cost = this.isParry ? this.getParryCostMultiply() : this.getGuardCostMultiply();
                float stamina = this.getStamina() - impact * cost;
                this.setStamina(stamina);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((PathfinderMob)this.getOriginal()).f_19853_, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, this.getOriginal(), damageSource.m_7640_());
                if (stamina >= 0.0f) {
                    float counter_cost = this.getCounterStamina();
                    RandomSource random = ((PathfinderMob)this.getOriginal()).m_217043_();
                    this.rotateTo(damageSource.m_7640_(), 30.0f, true);
                    if (random.m_188501_() < this.getCounterChance() && stamina >= counter_cost) {
                        if (this.stun_immunity_time > 0) {
                            ((PathfinderMob)this.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), this.stun_immunity_time));
                        }
                        this.setAttackSpeed(this.getCounterSpeed());
                        this.playAnimationSynchronized(this.getCounter(), 0.0f);
                        this.playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                        if (this.cancel_block) {
                            this.setBlocking(false);
                        }
                        this.setStamina(this.getStamina() - counter_cost);
                    } else if (this.isParry) {
                        if (this.parryCounter + 1 >= this.maxParryTimes) {
                            this.setBlocking(false);
                            if (this.stun_immunity_time > 0) {
                                ((PathfinderMob)this.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), this.stun_immunity_time));
                            }
                        }
                        this.playAnimationSynchronized(this.getParryAnimation(), 0.0f);
                        ++this.parryCounter;
                        ++this.parryTimes;
                        this.playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                        this.knockBackEntity(damageSource.m_7640_().m_20182_(), 0.4f * knockback);
                    } else {
                        this.playAnimationSynchronized(success, 0.1f);
                        this.playSound(animation.isShield != false ? SoundEvents.f_12346_ : (SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                        this.knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
                    }
                    return new AttackResult(AttackResult.ResultType.BLOCKED, amount);
                }
                this.setBlocking(false);
                this.applyStun(StunType.NEUTRALIZE, 2.0f);
                this.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), -0.05f, 0.1f);
                ((HitParticleType)EpicFightParticles.AIR_BURST.get()).spawnParticleWithArgument((ServerLevel)((PathfinderMob)this.getOriginal()).f_19853_, this.getOriginal(), damageSource.m_7640_());
                this.setStamina(this.getMaxStamina());
                return new AttackResult(AttackResult.ResultType.SUCCESS, amount / 2.0f);
            }
        }
        return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
    }

    public EpicFightDamageSource getDamageSource(StaticAnimation animation, InteractionHand hand) {
        EpicFightDamageSource damagesource = EpicFightDamageSource.commonEntityDamageSource((String)"mob", (LivingEntity)((LivingEntity)this.original), (StaticAnimation)animation);
        damagesource.setImpact(this.getImpact(hand));
        damagesource.setArmorNegation(this.getArmorNegation(hand));
        damagesource.setHurtItem(((PathfinderMob)this.original).m_21120_(hand));
        if (this.damageSourceModifier != null) {
            damagesource.setImpact(this.getImpact(hand) * this.damageSourceModifier.impact());
            damagesource.setArmorNegation(Math.min(100.0f, this.getArmorNegation(hand) * this.damageSourceModifier.armor_negation()));
        }
        return damagesource;
    }

    public void onDeath(LivingDeathEvent event) {
        this.resetMotion();
        this.setBlocking(false);
        this.getAnimator().playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
        if (this.hasBossBar && !((PathfinderMob)this.getOriginal()).m_213877_()) {
            this.bossInfo.update();
        }
    }

    public float getModifiedBaseDamage(float baseDamage) {
        if (this.damageSourceModifier != null) {
            baseDamage *= this.damageSourceModifier.damage();
        }
        return baseDamage;
    }

    public boolean applyStun(StunType stunType, float time) {
        if (this.neutralized) {
            stunType = stunType == StunType.KNOCKDOWN ? stunType : StunType.NONE;
        } else if (this.staminaLoseMultiply > 0.0f && this.lastGetImpact > 0.0f && this.getStunShield() <= 0.0f) {
            this.setStamina(this.getStamina() - this.lastGetImpact * this.staminaLoseMultiply);
            if (this.getStamina() < this.lastGetImpact * this.staminaLoseMultiply) {
                stunType = StunType.NEUTRALIZE;
                this.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), -0.05f, 0.1f);
                if (this.lastAttacker != null) {
                    ((HitParticleType)EpicFightParticles.AIR_BURST.get()).spawnParticleWithArgument((ServerLevel)((PathfinderMob)this.getOriginal()).f_19853_, this.getOriginal(), this.lastAttacker);
                }
                this.setStamina(this.getMaxStamina());
            }
        }
        if (!this.stunEvents.isEmpty() && this.getHitAnimation(stunType) != null) {
            for (CommandEvent.StunEvent event : this.stunEvents) {
                event.testAndExecute((LivingEntityPatch<?>)this, this.lastAttacker, stunType.ordinal());
                if (((PathfinderMob)this.getOriginal()).m_6084_() && !this.stunEvents.isEmpty()) continue;
                break;
            }
        }
        if (stunType != StunType.NONE) {
            this.setAttackSpeed(1.0f);
            this.resetActionTick();
            this.resetMotion();
        }
        boolean isStunned = super.applyStun(stunType, time);
        if (stunType == StunType.NEUTRALIZE) {
            this.neutralized = true;
        }
        return isStunned;
    }

    public void onFall(LivingFallEvent event) {
        super.onFall(event);
        this.setAttackSpeed(1.0f);
        this.resetActionTick();
        this.resetMotion();
        if (!this.stunEvents.isEmpty()) {
            for (CommandEvent.StunEvent stunEvent : this.stunEvents) {
                stunEvent.testAndExecute((LivingEntityPatch<?>)this, this.lastAttacker, StunType.FALL.ordinal());
                if (((PathfinderMob)this.getOriginal()).m_6084_() && !this.stunEvents.isEmpty()) continue;
                break;
            }
        }
    }

    public void knockBackEntity(Vec3 sourceLocation, float power) {
        if (this.neutralized) {
            return;
        }
        super.knockBackEntity(sourceLocation, power);
    }

    public StaticAnimation getHitAnimation(StunType stunType) {
        return this.provider.getStunAnimations().get(stunType);
    }

    public void onStartTracking(ServerPlayer trackingPlayer) {
        super.onStartTracking(trackingPlayer);
        if (this.hasBossBar) {
            this.bossInfo.m_6543_(trackingPlayer);
            if (!this.isLogicalClient()) {
                SPSpawnData packet = new SPSpawnData(((PathfinderMob)this.original).m_19879_());
                packet.getBuffer().writeLong(this.bossInfo.m_18860_().getMostSignificantBits());
                packet.getBuffer().writeLong(this.bossInfo.m_18860_().getLeastSignificantBits());
                EpicFightNetworkManager.sendToPlayer((Object)packet, (ServerPlayer)trackingPlayer);
            }
        }
    }

    public void onStopTracking(ServerPlayer trackingPlayer) {
        if (this.hasBossBar) {
            this.bossInfo.m_6539_(trackingPlayer);
        }
    }

    public void processSpawnData(ByteBuf buf) {
        long mostSignificant = buf.readLong();
        long leastSignificant = buf.readLong();
        UUID uuid = new UUID(mostSignificant, leastSignificant);
        BossBarGUi.BossBarEntities.put(uuid, this);
    }

    public record DamageSourceModifier(float damage, float impact, float armor_negation) {
    }

    public record CounterMotion(StaticAnimation counter, float cost, float chance, float speed) {
    }

    public static class GuardMotion {
        private final StaticAnimation guard_animation;
        private final boolean canBlockProjectile;
        private final float cost;
        private final float parry_cost;
        private final StaticAnimation[] parry_animation;

        public GuardMotion(StaticAnimation guard_animation, boolean canBlockProjectile, float cost, float parry_cost, StaticAnimation[] parry_animation) {
            this.guard_animation = guard_animation;
            this.canBlockProjectile = canBlockProjectile;
            this.cost = cost;
            this.parry_cost = parry_cost;
            this.parry_animation = parry_animation;
        }

        public GuardMotion(StaticAnimation guard_animation, boolean canBlockProjectile, float cost) {
            this.guard_animation = guard_animation;
            this.canBlockProjectile = canBlockProjectile;
            this.cost = cost;
            this.parry_cost = 0.5f;
            this.parry_animation = new StaticAnimation[]{Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2};
        }
    }

    public record CustomAnimationMotion(StaticAnimation animation, float convertTime, float speed, float stamina) {
    }
}

