/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.ai.task;

import com.google.common.collect.ImmutableMap;
import com.nameless.indestructible.mixin.CombatBehaviorsMixin;
import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedCombatBehavior<T extends MobPatch<?>>
extends Behavior<Mob> {
    protected final T mobpatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public AdvancedCombatBehavior(T mobpatch, CombatBehaviors<T> combatBehaviors) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT));
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    protected boolean checkExtraStartConditions(ServerLevel levelIn, Mob entityIn) {
        return !this.isHoldingRangeWeapon(entityIn) && this.isValidTarget(this.mobpatch.getTarget());
    }

    protected boolean canStillUse(ServerLevel levelIn, Mob entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(levelIn, entityIn) && BehaviorUtils.m_22667_((LivingEntity)entityIn, (LivingEntity)this.mobpatch.getTarget()) && !this.mobpatch.getEntityState().hurt();
    }

    protected void tick(ServerLevel worldIn, Mob entityIn, long gameTimeIn) {
        boolean inaction;
        T t = this.mobpatch;
        if (!(t instanceof AdvancedCustomHumanoidMobPatch)) {
            return;
        }
        AdvancedCustomHumanoidMobPatch ACHMobpatch = (AdvancedCustomHumanoidMobPatch)((Object)t);
        boolean bl = inaction = ACHMobpatch.isBlocking() || ACHMobpatch.getInactionTime() > 0;
        if (this.mobpatch.getTarget() != null) {
            CombatBehaviors.Behavior result;
            EntityState state = this.mobpatch.getEntityState();
            this.combatBehaviors.tick();
            if (this.combatBehaviors.hasActivatedMove()) {
                CombatBehaviors.Behavior result2;
                if (state.hurt() && state.hurtLevel() >= ACHMobpatch.getHurtResistLevel()) {
                    ((CombatBehaviorsMixin)this.combatBehaviors).setCurrentBehaviorPointer(-1);
                    return;
                }
                if (state.canBasicAttack() && !inaction && (result2 = this.combatBehaviors.tryProceed()) != null) {
                    ACHMobpatch.resetMotion();
                    result2.execute(this.mobpatch);
                }
            } else if (!state.inaction() && !inaction && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
                ACHMobpatch.resetMotion();
                result.execute(this.mobpatch);
            }
        }
    }

    private boolean isHoldingRangeWeapon(Mob mob) {
        return mob.m_21093_(stack -> {
            Item item = stack.m_41720_();
            return item instanceof ProjectileWeaponItem && mob.m_5886_((ProjectileWeaponItem)item);
        });
    }

    protected boolean isValidTarget(LivingEntity attackTarget) {
        return attackTarget != null && attackTarget.m_6084_() && (!(attackTarget instanceof Player) || !attackTarget.m_5833_() && !((Player)attackTarget).m_7500_());
    }
}

