/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class BossBarGUi {
    public static final Map<UUID, AdvancedCustomHumanoidMobPatch<?>> BossBarEntities = Maps.newHashMap();
    public static final List<String> cancelBossBar = new ArrayList<String>();

    @SubscribeEvent
    public void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (!cancelBossBar.isEmpty()) {
            for (String bossEventName : cancelBossBar) {
                if (!event.getBossEvent().m_18861_().getString().equals(bossEventName)) continue;
                event.setCanceled(true);
                event.setIncrement(0);
            }
        }
        BossBarEntities.values().forEach(k -> {
            if (event.getBossEvent().m_18861_().getString().contains(((PathfinderMob)k.getOriginal()).m_5446_().getString())) {
                event.setCanceled(true);
                event.setIncrement(0);
            }
        });
        if (!event.getBossEvent().m_18861_().getString().equals("advanced epic fight boss")) {
            return;
        }
        UUID infoID = event.getBossEvent().m_18860_();
        AdvancedCustomHumanoidMobPatch<?> achPatch = BossBarEntities.get(infoID);
        if (achPatch != null) {
            event.setCanceled(true);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)achPatch.getBossBar());
            int l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)((PathfinderMob)achPatch.getOriginal()).m_5446_());
            int i1 = event.getWindow().m_85445_() / 2 - l / 2;
            int x = event.getX() - 36;
            int y = event.getY();
            if (event.getY() >= Minecraft.m_91087_().m_91268_().m_85446_() / 3) {
                return;
            }
            PoseStack barPoseStack = event.getPoseStack();
            barPoseStack.m_85836_();
            barPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            float healthRatio = Mth.m_14036_((float)(((PathfinderMob)achPatch.getOriginal()).m_21223_() / ((PathfinderMob)achPatch.getOriginal()).m_21233_()), (float)0.0f, (float)1.0f);
            int health = (int)(256.0f * healthRatio);
            float staminaRatio = Mth.m_14036_((float)(achPatch.getStamina() / achPatch.getMaxStamina()), (float)0.0f, (float)1.0f);
            int stamina = (int)(256.0f * staminaRatio);
            GuiComponent.m_93133_((PoseStack)barPoseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)256, (int)19, (int)255, (int)255);
            GuiComponent.m_93133_((PoseStack)barPoseStack, (int)x, (int)y, (float)0.0f, (float)21.0f, (int)health, (int)19, (int)255, (int)255);
            GuiComponent.m_93133_((PoseStack)barPoseStack, (int)x, (int)(y + 18), (float)0.0f, (float)42.0f, (int)256, (int)10, (int)255, (int)255);
            GuiComponent.m_93133_((PoseStack)barPoseStack, (int)x, (int)(y + 18), (float)0.0f, (float)55.0f, (int)stamina, (int)10, (int)255, (int)255);
            GuiComponent.m_93133_((PoseStack)barPoseStack, (int)x, (int)y, (float)0.0f, (float)68.0f, (int)256, (int)29, (int)255, (int)255);
            barPoseStack.m_85849_();
            Minecraft.m_91087_().f_91062_.m_92763_(event.getPoseStack(), achPatch.getCustomName(), (float)i1, (float)(y - 9), 0xFFFFFF);
            event.setIncrement(44);
        }
    }
}

