/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.api.animation.types;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

public class CommandEvent {
    private final Consumer<LivingEntityPatch<?>> event;

    private CommandEvent(Consumer<LivingEntityPatch<?>> event) {
        this.event = event;
    }

    public void testAndExecute(LivingEntityPatch<?> entitypatch) {
        if (!entitypatch.isLogicalClient()) {
            this.event.accept(entitypatch);
        }
    }

    public static class StunEvent
    extends HitEvent {
        private final int condition;

        private StunEvent(BiConsumer<LivingEntityPatch<?>, Entity> event, int condition) {
            super(event);
            this.condition = condition;
        }

        public static StunEvent CreateStunCommandEvent(String command, boolean isTarget, StunType stunType) {
            BiConsumer<LivingEntityPatch<?>, Entity> event = (entitypatch, target) -> {
                Level server = ((LivingEntity)entitypatch.getOriginal()).f_19853_;
                CommandSourceStack css = ((LivingEntity)entitypatch.getOriginal()).m_20203_().m_81325_(2).m_81324_();
                if (isTarget && target instanceof LivingEntity) {
                    css = css.m_81329_(target);
                }
                if (server.m_7654_() != null && entitypatch.getOriginal() != null) {
                    server.m_7654_().m_129892_().m_230957_(css, command);
                }
            };
            return new StunEvent(event, stunType.ordinal());
        }

        public void testAndExecute(LivingEntityPatch<?> entitypatch, Entity target, int condition) {
            if (!entitypatch.isLogicalClient() && this.condition == condition) {
                this.event.accept(entitypatch, target);
            }
        }
    }

    public static class HitEvent {
        protected final BiConsumer<LivingEntityPatch<?>, Entity> event;

        private HitEvent(BiConsumer<LivingEntityPatch<?>, Entity> event) {
            this.event = event;
        }

        public static HitEvent CreateHitCommandEvent(String command, boolean isTarget) {
            BiConsumer<LivingEntityPatch<?>, Entity> event = (entitypatch, target) -> {
                Level server = ((LivingEntity)entitypatch.getOriginal()).f_19853_;
                CommandSourceStack css = ((LivingEntity)entitypatch.getOriginal()).m_20203_().m_81325_(2).m_81324_();
                if (isTarget && target instanceof LivingEntity) {
                    css = css.m_81329_(target);
                }
                if (server.m_7654_() != null && entitypatch.getOriginal() != null) {
                    server.m_7654_().m_129892_().m_230957_(css, command);
                }
            };
            return new HitEvent(event);
        }

        public void testAndExecute(LivingEntityPatch<?> entitypatch, Entity target) {
            if (!entitypatch.isLogicalClient()) {
                this.event.accept(entitypatch, target);
            }
        }
    }

    public static class TimeStampedEvent
    extends CommandEvent
    implements Comparable<TimeStampedEvent> {
        private final float time;

        private TimeStampedEvent(float time, Consumer<LivingEntityPatch<?>> event) {
            super(event);
            this.time = time;
        }

        public void testAndExecute(LivingEntityPatch<?> entitypatch, float prevElapsed, float elapsed) {
            if (this.time >= prevElapsed && this.time < elapsed) {
                super.testAndExecute(entitypatch);
            }
        }

        @Override
        public int compareTo(TimeStampedEvent event) {
            if (this.time == event.time) {
                return 0;
            }
            return this.time > event.time ? 1 : -1;
        }

        public static TimeStampedEvent CreateTimeCommandEvent(float time, String command, boolean isTarget) {
            Consumer<LivingEntityPatch<?>> event = entitypatch -> {
                Level server = ((LivingEntity)entitypatch.getOriginal()).f_19853_;
                CommandSourceStack css = ((LivingEntity)entitypatch.getOriginal()).m_20203_().m_81325_(2).m_81324_();
                if (isTarget && entitypatch.getTarget() != null) {
                    css = css.m_81329_((Entity)entitypatch.getTarget());
                }
                if (server.m_7654_() != null && entitypatch.getOriginal() != null) {
                    server.m_7654_().m_129892_().m_230957_(css, command);
                }
            };
            return new TimeStampedEvent(time, event);
        }
    }
}

