/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.entity;

import immersive_paintings.Config;
import immersive_paintings.Entities;
import immersive_paintings.Items;
import immersive_paintings.Main;
import immersive_paintings.ServerDataManager;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.compat.XercaPaintCompat;
import immersive_paintings.entity.AbstractImmersiveDecorationEntity;
import immersive_paintings.network.s2c.OpenGuiRequest;
import immersive_paintings.network.s2c.PaintingModifyMessage;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ImmersivePaintingEntity
extends AbstractImmersiveDecorationEntity {
    private ResourceLocation motive = Main.locate("none");
    private ResourceLocation frame = Main.locate("none");
    private ResourceLocation material = Main.locate("none");
    private int width = 1;
    private int height = 1;

    public ImmersivePaintingEntity(Level world, BlockPos pos, Direction direction, int rotation) {
        super(Entities.PAINTING, world, pos);
        this.setFacing(direction, rotation);
    }

    public ImmersivePaintingEntity(EntityType<Entity> type, Level world) {
        super(type, world);
    }

    public ImmersivePaintingEntity(EntityType<?> painting, Level world, BlockPos pos) {
        super(painting, world, pos);
    }

    @Override
    public int getWidthPixels() {
        return this.width * 16;
    }

    @Override
    public int getHeightPixels() {
        return this.height * 16;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("Motive", this.motive.toString());
        nbt.m_128359_("Frame", this.frame.toString());
        nbt.m_128359_("Material", this.material.toString());
        super.m_7380_(nbt);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        this.motive = new ResourceLocation(nbt.m_128461_("Motive"));
        this.frame = new ResourceLocation(nbt.m_128461_("Frame"));
        this.material = new ResourceLocation(nbt.m_128461_("Material"));
        this.updateMotiveDimensions();
        super.m_7378_(nbt);
    }

    public Item getDrop() {
        return Items.PAINTING;
    }

    @Override
    public void onBreak(@Nullable Entity entity) {
        if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (playerEntity.m_150110_().f_35937_) {
                return;
            }
        }
        this.m_19998_((ItemLike)this.getDrop());
    }

    @Override
    public void onPlace() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
        this.m_6034_(x, y, z);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        BlockPos blockPos = this.attachmentPos.m_7637_(x - this.m_20185_(), y - this.m_20186_(), z - this.m_20189_());
        this.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_6457_(ServerPlayer player) {
        ServerDataManager.playerRequestedImages(player);
        NetworkHandler.sendToPlayer(new PaintingModifyMessage(this), player);
        super.m_6457_(player);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDrop());
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            if (serverPlayerEntity.f_8941_.m_9290_() != GameType.ADVENTURE) {
                if (!XercaPaintCompat.interactWithPainting(this, player, hand)) {
                    Config config = Config.getInstance();
                    NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.EDITOR, this.m_19879_(), config.minPaintingResolution, config.maxPaintingResolution, config.showOtherPlayersPaintings, config.uploadPermissionLevel), (ServerPlayer)player);
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public ResourceLocation getMotive() {
        return this.motive;
    }

    public void setMotive(ResourceLocation motive) {
        this.motive = motive;
        this.updateMotiveDimensions();
        this.updateAttachmentPosition();
    }

    public void updateMotiveDimensions() {
        Painting painting = this.f_19853_.f_46443_ ? ClientPaintingManager.getPainting(this.motive) : ServerPaintingManager.getPainting(this.motive);
        if (painting != null) {
            this.width = painting.width;
            this.height = painting.height;
        }
    }

    public ResourceLocation getFrame() {
        return this.frame;
    }

    public void setFrame(ResourceLocation frame) {
        this.frame = frame;
    }

    public ResourceLocation getMaterial() {
        return this.material;
    }

    public void setMaterial(ResourceLocation material) {
        this.material = material;
    }

    public boolean isGraffiti() {
        return false;
    }
}

