/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.entity;

import immersive_paintings.Config;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImmersiveDecorationEntity
extends Entity {
    protected static final Predicate<Entity> PREDICATE = entity -> entity instanceof AbstractImmersiveDecorationEntity;
    private int obstructionCheckCounter;
    protected BlockPos attachmentPos;
    protected Direction facing = Direction.SOUTH;
    protected int rotation = 0;
    private static final Map<Direction, Byte> DIRECTION_TO_ID = Map.of(Direction.DOWN, (byte)5, Direction.UP, (byte)4, Direction.NORTH, (byte)2, Direction.SOUTH, (byte)0, Direction.WEST, (byte)1, Direction.EAST, (byte)3);
    private static final Map<Byte, Direction> ID_TO_DIRECTION = Map.of((byte)5, Direction.DOWN, (byte)4, Direction.UP, (byte)2, Direction.NORTH, (byte)0, Direction.SOUTH, (byte)1, Direction.WEST, (byte)3, Direction.EAST);

    protected AbstractImmersiveDecorationEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
    }

    protected AbstractImmersiveDecorationEntity(EntityType<? extends Entity> type, Level world, BlockPos pos) {
        this(type, world);
        this.attachmentPos = pos;
    }

    protected void m_8097_() {
    }

    public void setFacing(Direction facing, int rotation) {
        this.facing = facing;
        this.rotation = rotation;
        if (this.facing.m_122434_().m_122479_()) {
            this.m_146922_(this.facing.m_122416_() * 90);
            this.m_146926_(0.0f);
        } else {
            this.m_146922_(rotation);
            this.m_146926_(this.facing == Direction.UP ? 90.0f : -90.0f);
        }
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.updateAttachmentPosition();
    }

    protected void updateAttachmentPosition() {
        if (this.facing == null) {
            return;
        }
        double x = (double)this.attachmentPos.m_123341_() + 0.5;
        double y = (double)this.attachmentPos.m_123342_() + 0.5;
        double z = (double)this.attachmentPos.m_123343_() + 0.5;
        double ox = this.isEven(this.getWidthPixels());
        double oy = this.isEven(this.getHeightPixels());
        Vec3i front = this.facing.m_122436_();
        Vec3i up = this.facing.m_122434_().m_122478_() ? new Vec3i(0, 0, 1) : new Vec3i(0, 1, 0);
        Vec3i side = up.m_7724_(front);
        if (this.rotation != 0) {
            double cos = Math.cos((double)this.rotation / 180.0 * Math.PI);
            double sin = Math.sin((double)this.rotation / 180.0 * Math.PI);
            up = new Vec3i((double)Math.round((double)up.m_123341_() * cos - (double)up.m_123343_() * sin), (double)up.m_123342_(), (double)Math.round((double)up.m_123341_() * sin + (double)up.m_123343_() * cos));
            side = new Vec3i((double)Math.round((double)side.m_123341_() * cos - (double)side.m_123343_() * sin), (double)side.m_123342_(), (double)Math.round((double)side.m_123341_() * sin + (double)side.m_123343_() * cos));
        }
        double w = (double)this.getWidthPixels() / 32.0;
        double h = (double)this.getHeightPixels() / 32.0;
        double d = 0.03125;
        this.m_20343_(x -= (double)this.facing.m_122429_() * 7.5 / 16.0 - (double)up.m_123341_() * oy - (double)side.m_123341_() * ox, y -= (double)this.facing.m_122430_() * 7.5 / 16.0 - (double)up.m_123342_() * oy - (double)side.m_123342_() * ox, z -= (double)this.facing.m_122431_() * 7.5 / 16.0 - (double)up.m_123343_() * oy - (double)side.m_123343_() * ox);
        this.m_20011_(new AABB(x - (double)up.m_123341_() * h - (double)side.m_123341_() * w - (double)front.m_123341_() * d, y - (double)up.m_123342_() * h - (double)side.m_123342_() * w - (double)front.m_123342_() * d, z - (double)up.m_123343_() * h - (double)side.m_123343_() * w - (double)front.m_123343_() * d, x + (double)up.m_123341_() * h + (double)side.m_123341_() * w + (double)front.m_123341_() * d, y + (double)up.m_123342_() * h + (double)side.m_123342_() * w + (double)front.m_123342_() * d, z + (double)up.m_123343_() * h + (double)side.m_123343_() * w + (double)front.m_123343_() * d));
    }

    private double isEven(int i) {
        return i % 32 == 0 ? 0.5 : 0.0;
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.m_146871_();
            if (this.obstructionCheckCounter++ == 100) {
                this.obstructionCheckCounter = 0;
                if (!this.m_213877_() && !this.canStayAttached()) {
                    this.m_146870_();
                    this.onBreak(null);
                }
            }
        }
    }

    public boolean canStayAttached() {
        if (Config.getInstance().testIfSpaceEmpty && !this.f_19853_.m_45786_((Entity)this)) {
            return false;
        }
        BlockPos blockPos = this.attachmentPos.m_121945_(this.facing.m_122424_());
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        if (!blockState.m_60767_().m_76333_() && !DiodeBlock.m_52586_((BlockState)blockState)) {
            return false;
        }
        return this.f_19853_.m_6249_((Entity)this, this.m_20191_(), PREDICATE).stream().noneMatch(v -> ((AbstractImmersiveDecorationEntity)v).facing == this.facing);
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean m_5829_() {
        return Config.getInstance().paintingsHaveCollision;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_7313_(Entity attacker) {
        if (attacker instanceof Player) {
            Player playerEntity = (Player)attacker;
            if (!this.f_19853_.m_7966_(playerEntity, this.attachmentPos)) {
                return true;
            }
            return this.m_6469_(DamageSource.m_19344_((Player)playerEntity), 0.0f);
        }
        return false;
    }

    public Direction m_6350_() {
        return this.facing;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_213877_() && !this.f_19853_.f_46443_) {
            this.m_6074_();
            this.m_5834_();
            this.onBreak(source.m_7639_());
        }
        return true;
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        if (!this.f_19853_.f_46443_ && !this.m_213877_() && movement.m_82556_() > 0.0) {
            this.m_6074_();
            this.onBreak(null);
        }
    }

    public void m_5997_(double deltaX, double deltaY, double deltaZ) {
        if (!this.f_19853_.f_46443_ && !this.m_213877_() && deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 0.0) {
            this.m_6074_();
            this.onBreak(null);
        }
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("TileX", this.attachmentPos.m_123341_());
        nbt.m_128405_("TileY", this.attachmentPos.m_123342_());
        nbt.m_128405_("TileZ", this.attachmentPos.m_123343_());
        nbt.m_128344_("Facing", DIRECTION_TO_ID.get(this.facing).byteValue());
        nbt.m_128405_("Rotation", this.rotation);
    }

    public void m_7378_(CompoundTag nbt) {
        this.attachmentPos = new BlockPos(nbt.m_128451_("TileX"), nbt.m_128451_("TileY"), nbt.m_128451_("TileZ"));
        this.facing = ID_TO_DIRECTION.get(nbt.m_128445_("Facing"));
        this.rotation = nbt.m_128451_("Rotation");
        this.setFacing(this.facing, this.rotation);
    }

    public abstract int getWidthPixels();

    public abstract int getHeightPixels();

    public abstract void onBreak(@Nullable Entity var1);

    public abstract void onPlace();

    public ItemEntity m_5552_(ItemStack stack, float yOffset) {
        ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_() + (double)this.facing.m_122429_() * 0.3, this.m_20186_() + (double)this.facing.m_122430_() * 0.3 + (double)yOffset, this.m_20189_() + (double)this.facing.m_122431_() * 0.3, stack);
        itemEntity.m_32060_();
        this.f_19853_.m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        this.attachmentPos = new BlockPos(x, y, z);
        this.updateAttachmentPosition();
        this.f_19812_ = true;
    }

    public float m_7890_(Rotation rotation) {
        if (this.facing.m_122434_() != Direction.Axis.Y) {
            switch (rotation) {
                case CLOCKWISE_180: {
                    this.facing = this.facing.m_122424_();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.facing = this.facing.m_122428_();
                    break;
                }
                case CLOCKWISE_90: {
                    this.facing = this.facing.m_122427_();
                }
            }
        }
        float f = Mth.m_14177_((float)this.m_146908_());
        switch (rotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    public float m_6961_(Mirror mirror) {
        return this.m_7890_(mirror.m_54846_(this.facing));
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
    }

    public void m_6210_() {
    }

    public BlockPos getAttachmentPos() {
        return this.attachmentPos;
    }

    public void setAttachmentPos(BlockPos pos) {
        this.attachmentPos = pos;
        this.updateAttachmentPosition();
    }
}

