/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChorusPetalParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    protected final float rotationFactor;
    private final int variant = RANDOM.nextInt(3);
    private final SpriteSet spriteProvider;

    public ChorusPetalParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.spriteProvider = spriteProvider;
        this.f_107663_ *= 1.0f + RANDOM.nextFloat();
        this.f_107225_ = 30 + this.f_107223_.m_188503_(60);
        this.f_107219_ = true;
        this.m_108337_(spriteProvider.m_5819_(this.variant, 2));
        if (velocityY == 0.0 && velocityX == 0.0 && velocityZ == 0.0) {
            this.f_107230_ = 0.0f;
        }
        this.f_107216_ = velocityY - 0.15 - (double)(this.f_107223_.m_188501_() / 10.0f);
        this.f_107215_ = velocityX - 0.05 - (double)(this.f_107223_.m_188501_() / 10.0f);
        this.f_107217_ = velocityZ - 0.05 - (double)(this.f_107223_.m_188501_() / 10.0f);
        this.rotationFactor = ((float)Math.random() - 0.5f) * 0.01f;
        this.f_107231_ = this.f_107223_.m_188501_() * 360.0f;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternion quaternion2;
        this.f_107227_ = Math.max(this.f_107228_, 0.3f);
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion2 = camera.m_90591_();
        } else {
            quaternion2 = new Quaternion(camera.m_90591_());
            float i = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion2.m_80148_(Vector3f.f_122227_.m_122240_(i));
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.m_122251_(quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.m_122251_(quaternion2);
            Vec3f2.m_122261_(j);
            Vec3f2.m_122272_(f, g, h);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int l = 0xF000F0;
        vertexConsumer.m_5483_((double)Vec3fs[0].m_122239_(), (double)Vec3fs[0].m_122260_(), (double)Vec3fs[0].m_122269_()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].m_122239_(), (double)Vec3fs[1].m_122260_(), (double)Vec3fs[1].m_122269_()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].m_122239_(), (double)Vec3fs[2].m_122260_(), (double)Vec3fs[2].m_122269_()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].m_122239_(), (double)Vec3fs[3].m_122260_(), (double)Vec3fs[3].m_122269_()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.f_107224_++ < this.f_107225_) {
            this.f_107230_ = Math.min(1.0f, this.f_107230_ + 0.1f);
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107215_ *= 0.99;
        this.f_107216_ *= 0.99;
        this.f_107217_ *= 0.99;
        this.f_107227_ = (float)((double)this.f_107227_ * 0.99);
        this.f_107228_ = (float)((double)this.f_107228_ * 0.98);
        if (this.f_107224_ >= this.f_107225_) {
            this.f_107230_ = Math.max(0.0f, this.f_107230_ - 0.1f);
            if (this.f_107230_ <= 0.0f) {
                this.m_107274_();
            }
        }
        this.f_107204_ = this.f_107231_;
        if (this.f_107218_ || this.f_107208_.m_6425_(new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_)).m_205070_(FluidTags.f_13131_)) {
            this.f_107215_ = 0.0;
            this.f_107216_ = 0.0;
            this.f_107217_ = 0.0;
        }
        if (this.f_107216_ != 0.0) {
            this.f_107231_ = (float)((double)this.f_107231_ + Math.PI * Math.sin(this.rotationFactor * (float)this.f_107224_) / 2.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public DefaultFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new ChorusPetalParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

