/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.swaps;

import dev.shwg.smoothswapping.Vec2;
import net.minecraft.world.item.ItemStack;

public class InventorySwap {
    private double x;
    private double y;
    private final double distance;
    private final double startX;
    private final double startY;
    private final double angle;
    private boolean renderDestinationSlot;
    private final boolean checked;
    private final int amount;
    private final ItemStack swapItem;

    public InventorySwap(Vec2 fromVec, Vec2 toVec, ItemStack swapItem, boolean checked, int amount) {
        this.x = toVec.v[0] - fromVec.v[0];
        this.y = toVec.v[1] - fromVec.v[1];
        this.startX = toVec.v[0] - fromVec.v[0];
        this.startY = toVec.v[1] - fromVec.v[1];
        this.angle = (float)(Math.atan2(this.y, this.x) + Math.PI);
        this.distance = Math.hypot(this.x, this.y);
        this.renderDestinationSlot = false;
        this.checked = checked;
        this.amount = amount;
        this.swapItem = swapItem;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean renderDestinationSlot() {
        return this.renderDestinationSlot;
    }

    public void setRenderDestinationSlot(boolean renderDestinationSlot) {
        this.renderDestinationSlot = renderDestinationSlot;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public int getAmount() {
        return this.amount;
    }

    public ItemStack getSwapItem() {
        return this.swapItem;
    }

    public String toString() {
        return "InventorySwap{x=" + this.x + ", y=" + this.y + ", distance=" + this.distance + ", startX=" + this.startX + ", startY=" + this.startY + ", angle=" + this.angle + ", renderDestinationSlot=" + this.renderDestinationSlot + ", checked=" + this.checked + ", amount=" + this.amount + ", swapItem=" + this.swapItem + "}";
    }
}

