/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mainwindow;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WindowHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final File ICON_DIR = new File(FancyMenu.MOD_DIR, "/minecraftwindow/icons");
    private static String windowTitle = null;

    public static void handleForceFullscreen() {
        try {
            FancyMenu.initConfig();
            if (((Boolean)FancyMenu.config.getOrDefault("forcefullscreen", (Object)false)).booleanValue() && !Minecraft.m_91087_().m_91268_().m_85440_()) {
                Minecraft.m_91087_().m_91268_().m_85438_();
                LOGGER.info("[FANCYMENU] Forced window to fullscreen!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateWindowIcon() {
        FancyMenu.initConfig();
        if (((Boolean)FancyMenu.config.getOrDefault("customwindowicon", (Object)false)).booleanValue()) {
            try {
                File i16 = new File(ICON_DIR.getPath() + "/icon16x16.png");
                File i32 = new File(ICON_DIR.getPath() + "/icon32x32.png");
                if (!i16.exists() || !i32.exists()) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon16x16.png' or 'icon32x32.png' missing!");
                    return;
                }
                BufferedImage i16buff = ImageIO.read(i16);
                if (i16buff.getHeight() != 16 || i16buff.getWidth() != 16) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon16x16.png' not 16x16!");
                    return;
                }
                BufferedImage i32buff = ImageIO.read(i32);
                if (i32buff.getHeight() != 32 || i32buff.getWidth() != 32) {
                    LOGGER.error("[FANCYMENU] Unable to set custom icons: 'icon32x32.png' not 32x32!");
                    return;
                }
                WindowHandler.setIcon(Files.newInputStream(i16.toPath(), new OpenOption[0]), Files.newInputStream(i32.toPath(), new OpenOption[0]));
                LOGGER.info("[FANCYMENU] Custom minecraft icon successfully loaded!");
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Failed to set custom window icon!");
                e.printStackTrace();
            }
        }
    }

    private static void setIcon(InputStream p_250818_, InputStream p_249199_) {
        RenderSystem.m_187551_();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.malloc((int)2, (MemoryStack)memorystack);
            ByteBuffer bytebuffer = WindowHandler.readIconPixels(p_250818_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = WindowHandler.readIconPixels(p_249199_, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                STBImage.stbi_image_free((ByteBuffer)bytebuffer);
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)Minecraft.m_91087_().m_91268_().m_85439_(), (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException ioexception) {
            LogManager.getLogger().error("Couldn't set icon", (Throwable)ioexception);
        }
    }

    @Nullable
    private static ByteBuffer readIconPixels(InputStream p_249586_, IntBuffer p_249069_, IntBuffer p_249100_, IntBuffer p_249695_) throws IOException {
        RenderSystem.m_187551_();
        ByteBuffer bytebuffer = null;
        try {
            ByteBuffer byteBuffer;
            block10: {
                InputStream inputstream = p_249586_;
                try {
                    bytebuffer = TextureUtil.m_85303_((InputStream)inputstream);
                    bytebuffer.rewind();
                    byteBuffer = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)p_249069_, (IntBuffer)p_249100_, (IntBuffer)p_249695_, (int)0);
                    if (inputstream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputstream.close();
            }
            return byteBuffer;
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
    }

    public static void updateWindowTitle() {
        WindowHandler.readCustomWindowTitleFromConfig();
        Minecraft.m_91087_().m_91341_();
    }

    public static void readCustomWindowTitleFromConfig() {
        FancyMenu.initConfig();
        windowTitle = (String)FancyMenu.config.getOrDefault("customwindowtitle", (Object)"");
        if (windowTitle != null && windowTitle.isEmpty()) {
            windowTitle = null;
        }
    }

    @Nullable
    public static String getCustomWindowTitle() {
        return windowTitle;
    }

    public static int getWindowGuiWidth() {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null) {
            double mcScale = Minecraft.m_91087_().m_91268_().m_85385_((int)Minecraft.m_91087_().m_91268_().m_85449_(), ((Boolean)Minecraft.m_91087_().f_91066_.m_231819_().m_231551_()).booleanValue());
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.f_96543_ / sc);
        }
        return 0;
    }

    public static int getWindowGuiHeight() {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null) {
            double mcScale = Minecraft.m_91087_().m_91268_().m_85385_((int)Minecraft.m_91087_().m_91268_().m_85449_(), ((Boolean)Minecraft.m_91087_().f_91066_.m_231819_().m_231551_()).booleanValue());
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.f_96544_ / sc);
        }
        return 0;
    }
}

