/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.handler;

import com.google.common.collect.BiMap;
import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.PlatformUtils;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.CrosshairVariant;
import mod.crend.dynamiccrosshair.component.ModifierUse;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.mixin.IAxeItemMixin;
import mod.crend.dynamiccrosshair.mixin.IHoeItemMixin;
import mod.crend.dynamiccrosshair.mixin.IShovelItemMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class VanillaUsableItemHandler {
    public static boolean isAlwaysUsableItem(ItemStack handItemStack) {
        Item handItem = handItemStack.m_41720_();
        return handItem.m_6164_(handItemStack) == UseAnim.DRINK || DynamicCrosshair.config.getAdditionalUsableItems().contains(handItem);
    }

    public static boolean isUsableItem(ItemStack handItemStack) {
        Item handItem = handItemStack.m_41720_();
        return handItem.m_41472_() || handItem instanceof ArmorItem || handItem instanceof ElytraItem || handItem instanceof FireworkRocketItem || handItem instanceof SpawnEggItem || handItem instanceof FireChargeItem || handItem instanceof RecordItem || handItem instanceof HoneycombItem || handItem instanceof EnderEyeItem || handItem instanceof BottleItem || handItem instanceof PotionItem || handItem instanceof BucketItem || handItem instanceof BoneMealItem || handItem instanceof WritableBookItem || handItem instanceof WrittenBookItem || handItem instanceof InstrumentItem;
    }

    public static Crosshair checkUsableItem(CrosshairContext context) {
        BlockHitResult blockHitResult;
        Item handItem = context.getItem();
        if (handItem.m_41472_()) {
            if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() != BlockCrosshairPolicy.Disabled && (handItem == Items.f_42780_ || handItem == Items.f_151079_) && context.isWithBlock() && context.canPlaceItemAsBlock()) {
                return Crosshair.HOLDING_BLOCK;
            }
            if (context.player.m_36391_(false) || handItem.m_41473_().m_38747_()) {
                return Crosshair.USABLE;
            }
        }
        if (handItem instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)handItem;
            EquipmentSlot slot = armorItem.m_40402_();
            if (context.player.m_21033_(slot)) {
                return null;
            }
            return Crosshair.USABLE;
        }
        if (handItem instanceof ElytraItem) {
            if (context.player.m_21033_(EquipmentSlot.CHEST)) {
                return null;
            }
            return Crosshair.USABLE;
        }
        if (handItem instanceof FireworkRocketItem && (context.isWithBlock() || context.player.m_21255_())) {
            return Crosshair.USABLE;
        }
        if (handItem instanceof InstrumentItem) {
            if (context.player.m_36335_().m_41519_(handItem)) {
                return null;
            }
            return Crosshair.USABLE;
        }
        if (handItem instanceof BottleItem) {
            List list = context.world.m_6443_(AreaEffectCloud.class, context.player.m_20191_().m_82400_(2.0), entity -> entity != null && entity.m_6084_() && entity.m_19745_().m_6012_() == ParticleTypes.f_123799_);
            if (!list.isEmpty()) {
                return Crosshair.USABLE;
            }
            BlockHitResult blockHitResult2 = context.raycastWithFluid(ClipContext.Fluid.ANY);
            if (context.world.m_6425_(blockHitResult2.m_82425_()).m_205070_(FluidTags.f_13131_)) {
                return Crosshair.USABLE;
            }
        }
        if (handItem == Items.f_42446_ && (blockHitResult = context.raycastWithFluid(ClipContext.Fluid.SOURCE_ONLY)).m_6662_() == HitResult.Type.BLOCK) {
            FluidState bucketFluidState = context.world.m_6425_(blockHitResult.m_82425_());
            if (!bucketFluidState.m_76178_() && bucketFluidState.m_76170_()) {
                return Crosshair.USABLE;
            }
            Block bucketBlock = context.world.m_8055_(blockHitResult.m_82425_()).m_60734_();
            if (bucketBlock instanceof BucketPickup && !(bucketBlock instanceof SimpleWaterloggedBlock) && !(bucketBlock instanceof LiquidBlock)) {
                return Crosshair.USABLE;
            }
        }
        if (context.isWithBlock()) {
            return VanillaUsableItemHandler.checkUsableItemOnBlock(context);
        }
        if (!context.isTargeting()) {
            return VanillaUsableItemHandler.checkUsableItemOnMiss(context);
        }
        return null;
    }

    public static Crosshair checkUsableTool(CrosshairContext context) {
        Item handItem = context.getItem();
        BlockState blockState = context.getBlockState();
        Block block = blockState.m_60734_();
        if (context.isWithBlock()) {
            if (handItem instanceof TieredItem) {
                if (handItem instanceof AxeItem ? IAxeItemMixin.getSTRIPPED_BLOCKS().get(block) != null || WeatheringCopper.m_154890_((Block)block).isPresent() || ((BiMap)HoneycombItem.f_150864_.get()).get((Object)block) != null : (handItem instanceof ShovelItem ? IShovelItemMixin.getPATH_STATES().get(block) != null : handItem instanceof HoeItem && IHoeItemMixin.getTILLING_ACTIONS().get(block) != null)) {
                    return Crosshair.USABLE;
                }
                return null;
            }
            if (handItem instanceof ShearsItem) {
                GrowingPlantHeadBlock plantStemBlock;
                if (block instanceof GrowingPlantHeadBlock && !(plantStemBlock = (GrowingPlantHeadBlock)block).m_187440_(blockState)) {
                    return Crosshair.USABLE;
                }
                if (!context.player.m_36341_() && block instanceof BeehiveBlock && (Integer)blockState.m_61143_((Property)BeehiveBlock.f_49564_) >= 5) {
                    return Crosshair.USABLE;
                }
                return null;
            }
        }
        return null;
    }

    public static Crosshair checkUsableItemOnBlock(CrosshairContext context) {
        Item handItem = context.getItem();
        if (handItem instanceof SpawnEggItem) {
            return Crosshair.USABLE;
        }
        BlockState blockState = context.getBlockState();
        Block block = blockState.m_60734_();
        Crosshair crosshair = VanillaUsableItemHandler.checkUsableTool(context);
        if (crosshair != null) {
            return crosshair;
        }
        if (handItem instanceof FlintAndSteelItem || handItem instanceof FireChargeItem) {
            if (CampfireBlock.m_51321_((BlockState)blockState) || CandleBlock.m_152845_((BlockState)blockState) || CandleCakeBlock.m_152910_((BlockState)blockState)) {
                return Crosshair.USABLE;
            }
            BlockPos firePos = context.getBlockPos().m_121945_(((BlockHitResult)context.hitResult).m_82434_());
            if (BaseFireBlock.m_49255_((Level)context.world, (BlockPos)firePos, (Direction)context.player.m_6350_())) {
                if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() != BlockCrosshairPolicy.Disabled) {
                    return Crosshair.HOLDING_BLOCK;
                }
                return Crosshair.USABLE;
            }
        }
        if (handItem instanceof RecordItem && block instanceof JukeboxBlock) {
            return Crosshair.USABLE;
        }
        if (handItem instanceof HoneycombItem && ((BiMap)HoneycombItem.f_150863_.get()).get((Object)block) != null) {
            return Crosshair.USABLE;
        }
        if (!(!(handItem instanceof EnderEyeItem) || block.equals(Blocks.f_50258_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61433_)).booleanValue())) {
            return Crosshair.USABLE;
        }
        if (handItem instanceof MobBucketItem) {
            if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() != BlockCrosshairPolicy.Disabled) {
                return new Crosshair(CrosshairVariant.HoldingBlock, ModifierUse.USE_ITEM);
            }
            return Crosshair.USABLE;
        }
        if (block instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock cauldron = (AbstractCauldronBlock)block;
            if (!context.player.m_36341_()) {
                if (handItem instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)handItem;
                    Fluid fluid = PlatformUtils.getFluidFromBucket(bucketItem);
                    if (fluid == Fluids.f_76193_ || fluid == Fluids.f_76195_) {
                        return Crosshair.USABLE;
                    }
                    if (fluid == Fluids.f_76191_ && cauldron.m_142596_(blockState)) {
                        return Crosshair.USABLE;
                    }
                }
                if (handItem instanceof SolidBucketItem) {
                    return Crosshair.USABLE;
                }
                if (block.equals(Blocks.f_152476_)) {
                    DyeableLeatherItem dyeableItem;
                    ShulkerBoxBlock sbb;
                    BlockItem blockItem;
                    Block block2;
                    if (handItem instanceof BottleItem) {
                        return Crosshair.USABLE;
                    }
                    if (handItem instanceof PotionItem && PotionUtils.m_43579_((ItemStack)context.getItemStack()) == Potions.f_43599_) {
                        return Crosshair.USABLE;
                    }
                    if (handItem instanceof BlockItem && (block2 = (blockItem = (BlockItem)handItem).m_40614_()) instanceof ShulkerBoxBlock && (sbb = (ShulkerBoxBlock)block2).m_56261_() != null) {
                        return Crosshair.USABLE;
                    }
                    if (handItem instanceof DyeableLeatherItem && (dyeableItem = (DyeableLeatherItem)handItem).m_41113_(context.getItemStack())) {
                        return Crosshair.USABLE;
                    }
                    if (handItem instanceof BannerItem && BannerBlockEntity.m_58504_((ItemStack)context.getItemStack()) > 0) {
                        return Crosshair.USABLE;
                    }
                }
            }
        }
        if (handItem instanceof BottleItem) {
            if (block instanceof BeehiveBlock && (Integer)blockState.m_61143_((Property)BeehiveBlock.f_49564_) >= 5 && !context.player.m_36341_()) {
                return Crosshair.USABLE;
            }
            return null;
        }
        if (handItem instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)handItem;
            Fluid fluid = PlatformUtils.getFluidFromBucket(bucketItem);
            if (fluid != Fluids.f_76191_) {
                if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() != BlockCrosshairPolicy.Disabled) {
                    return Crosshair.HOLDING_BLOCK;
                }
                return Crosshair.USABLE;
            }
            if (block instanceof SimpleWaterloggedBlock ? blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false : block instanceof BucketPickup) {
                return Crosshair.USABLE;
            }
        }
        if (handItem instanceof BoneMealItem) {
            BonemealableBlock fertilizable;
            if (block instanceof BonemealableBlock && (fertilizable = (BonemealableBlock)block).m_7370_((BlockGetter)context.world, context.getBlockPos(), blockState, true)) {
                return Crosshair.USABLE;
            }
            if (context.getBlockState().m_60713_(Blocks.f_49990_) && context.getFluidState().m_76186_() == 8) {
                return Crosshair.USABLE;
            }
            return null;
        }
        if (handItem instanceof CompassItem && block == Blocks.f_50729_) {
            return Crosshair.USABLE;
        }
        if (handItem instanceof WritableBookItem || handItem instanceof WrittenBookItem) {
            return Crosshair.USABLE;
        }
        return null;
    }

    public static Crosshair checkUsableItemOnMiss(CrosshairContext context) {
        Item handItem = context.getItem();
        if (DynamicCrosshair.config.dynamicCrosshairHoldingBlock() == BlockCrosshairPolicy.Always) {
            BucketItem bucketItem;
            if (handItem instanceof MobBucketItem) {
                return new Crosshair(CrosshairVariant.HoldingBlock, ModifierUse.USE_ITEM);
            }
            if (handItem instanceof BucketItem && PlatformUtils.getFluidFromBucket(bucketItem = (BucketItem)handItem) != Fluids.f_76191_) {
                return Crosshair.HOLDING_BLOCK;
            }
        }
        return null;
    }
}

