/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.handler;

import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.ModifierUse;
import mod.crend.dynamiccrosshair.mixin.IAbstractBlockMixin;
import mod.crend.dynamiccrosshair.mixin.IFlowerPotBlockMixin;
import mod.crend.dynamiccrosshair.mixin.IRedstoneWireBlockMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FletchingTableBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;

public class VanillaBlockHandler {
    public static Crosshair checkToolWithBlock(CrosshairContext context) {
        Item handItem = context.getItem();
        BlockPos blockPos = context.getBlockPos();
        BlockState blockState = context.getBlockState();
        if (blockState == null) {
            return null;
        }
        if (handItem instanceof DiggerItem) {
            if (handItem.m_8096_(blockState) && handItem.m_6777_(blockState, (Level)context.world, blockPos, (Player)context.player)) {
                return Crosshair.CORRECT_TOOL;
            }
            return Crosshair.INCORRECT_TOOL;
        }
        if (handItem.m_8102_(context.getItemStack(), blockState) > 1.0f && handItem.m_6777_(blockState, (Level)context.world, blockPos, (Player)context.player)) {
            return Crosshair.CORRECT_TOOL;
        }
        if (handItem instanceof ShearsItem) {
            return Crosshair.INCORRECT_TOOL;
        }
        return null;
    }

    public static boolean isAlwaysInteractableBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block instanceof AbstractChestBlock || block instanceof AbstractFurnaceBlock || block instanceof BarrelBlock || block instanceof BeaconBlock || block instanceof BellBlock || block instanceof BrewingStandBlock || block instanceof DaylightDetectorBlock || block instanceof DispenserBlock || block instanceof EnchantmentTableBlock || block instanceof HopperBlock || block instanceof ShulkerBoxBlock || block instanceof StonecutterBlock || block instanceof GrindstoneBlock || block instanceof CartographyTableBlock || block instanceof LoomBlock || block instanceof BedBlock || block instanceof TrapDoorBlock && ((IAbstractBlockMixin)block).getMaterial() != Material.f_76279_ || block instanceof DoorBlock && ((IAbstractBlockMixin)block).getMaterial() != Material.f_76279_ || block instanceof FenceGateBlock && ((IAbstractBlockMixin)block).getMaterial() != Material.f_76279_ || block instanceof ButtonBlock || block instanceof NoteBlock || block instanceof LeverBlock || block instanceof DiodeBlock || block instanceof AnvilBlock || block instanceof CraftingTableBlock && !(block instanceof FletchingTableBlock) || DynamicCrosshair.config.getAdditionalInteractableBlocks().contains(block);
    }

    public static boolean isInteractableBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block instanceof CommandBlock || block instanceof JukeboxBlock || block instanceof LecternBlock || block instanceof ComposterBlock || block instanceof FlowerPotBlock || block instanceof CakeBlock || block instanceof SweetBerryBushBlock || block instanceof AbstractCandleBlock || block instanceof CampfireBlock;
    }

    public static Crosshair checkBlockInteractable(CrosshairContext context) {
        CampfireBlockEntity campfire;
        BlockEntity blockEntity2;
        Item mainItem;
        BlockState blockState = context.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof CommandBlock && context.player.m_7500_() || block instanceof JukeboxBlock && (Boolean)blockState.m_61143_((Property)JukeboxBlock.f_54254_) != false || block instanceof LecternBlock && (Boolean)blockState.m_61143_((Property)LecternBlock.f_54467_) != false || block instanceof ComposterBlock && ComposterBlock.f_51914_.containsKey((Object)context.getItem())) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof FlowerPotBlock) {
            boolean handItemIsPottable;
            Item handItem = context.getItem();
            boolean potItemIsAir = ((FlowerPotBlock)block).m_53560_() == Blocks.f_50016_;
            boolean bl = handItemIsPottable = handItem instanceof BlockItem && IFlowerPotBlockMixin.getCONTENT_TO_POTTED().containsKey(((BlockItem)handItem).m_40614_());
            if (potItemIsAir && handItemIsPottable) {
                return Crosshair.USABLE;
            }
            if (!potItemIsAir && !handItemIsPottable) {
                return Crosshair.INTERACTABLE.withFlag(Crosshair.Flag.FixedStyle);
            }
            return Crosshair.NONE.withFlag(Crosshair.Flag.FixedStyle, Crosshair.Flag.FixedModifierUse);
        }
        if (block instanceof SignBlock) {
            BlockEntity blockEntity2;
            Item handItem = context.getItem();
            if ((handItem instanceof DyeItem || handItem.equals(Items.f_151056_) || handItem.equals(Items.f_42532_)) && (blockEntity2 = context.getBlockEntity()) instanceof SignBlockEntity) {
                SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity2;
                if (handItem.equals(Items.f_151056_) && !signBlockEntity.m_155727_()) {
                    return Crosshair.USABLE;
                }
                if (handItem.equals(Items.f_42532_) && signBlockEntity.m_155727_()) {
                    return Crosshair.USABLE;
                }
                if (handItem instanceof DyeItem && signBlockEntity.m_59753_() != ((DyeItem)handItem).m_41089_()) {
                    return Crosshair.USABLE;
                }
            }
            return Crosshair.NONE.withFlag(Crosshair.Flag.FixedStyle, Crosshair.Flag.FixedModifierUse);
        }
        if (block instanceof CakeBlock && context.player.m_36391_(false) && context.shouldInteract()) {
            return Crosshair.USABLE;
        }
        if (block instanceof SweetBerryBushBlock && (Integer)blockState.m_61143_((Property)SweetBerryBushBlock.f_57244_) > 1) {
            return Crosshair.USABLE;
        }
        if (block instanceof CaveVines && CaveVines.m_152951_((BlockState)blockState)) {
            return Crosshair.USABLE;
        }
        if (block instanceof RedStoneOreBlock && context.shouldInteract()) {
            return new Crosshair(ModifierUse.USE_ITEM).withFlag(Crosshair.Flag.FixedModifierUse);
        }
        if (!(!(block instanceof AbstractCandleBlock) || !((Boolean)blockState.m_61143_((Property)AbstractCandleBlock.f_151895_)).booleanValue() || (mainItem = context.getItem()).equals(Items.f_42409_) || mainItem instanceof BlockItem || mainItem instanceof SpawnEggItem || mainItem instanceof FireChargeItem || mainItem instanceof EnderEyeItem || mainItem instanceof EnderpearlItem || mainItem instanceof WritableBookItem || mainItem instanceof WrittenBookItem || mainItem instanceof PotionItem || mainItem.m_6164_(context.getItemStack()) == UseAnim.DRINK || mainItem.m_6164_(context.getItemStack()) == UseAnim.EAT && context.player.m_36391_(false))) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof LecternBlock) {
            Item handItem = context.getItem();
            if (handItem.equals(Items.f_42615_) || handItem.equals(Items.f_42614_) || !context.player.m_36341_() && ((Boolean)blockState.m_61143_((Property)LecternBlock.f_54467_)).booleanValue()) {
                return Crosshair.USABLE;
            }
            return Crosshair.NONE.withFlag(Crosshair.Flag.FixedModifierUse);
        }
        if (block instanceof CampfireBlock && (blockEntity2 = context.getBlockEntity()) instanceof CampfireBlockEntity && (campfire = (CampfireBlockEntity)blockEntity2).m_59051_(context.getItemStack()).isPresent()) {
            return Crosshair.USABLE;
        }
        if (block instanceof RedStoneWireBlock && (IRedstoneWireBlockMixin.invokeIsFullyConnected(blockState) || IRedstoneWireBlockMixin.invokeIsNotConnected(blockState))) {
            return Crosshair.INTERACTABLE;
        }
        if (blockState.m_204336_(BlockTags.f_13039_)) {
            BlockPos pos = context.getBlockPos();
            List list = context.world.m_45976_(Mob.class, new AABB((double)pos.m_123341_() - 7.0, (double)pos.m_123342_() - 7.0, (double)pos.m_123343_() - 7.0, (double)pos.m_123341_() + 7.0, (double)pos.m_123342_() + 7.0, (double)pos.m_123343_() + 7.0));
            for (Mob mob : list) {
                if (mob.m_21524_() != context.player) continue;
                return Crosshair.USABLE;
            }
        }
        return null;
    }
}

