/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.configuration.presence;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.hypherionmc.shaded.moonconfig.core.conversion.Path;
import me.hypherionmc.shaded.moonconfig.core.conversion.SpecComment;
import me.hypherionmc.shaded.moonconfig.core.fields.RandomArrayList;
import me.hypherionmc.simplerpclib.configuration.objects.Dimension;
import me.hypherionmc.simplerpclib.configuration.objects.RPCButton;
import me.hypherionmc.simplerpclib.configuration.objects.ServerEntry;
import me.hypherionmc.simplerpclib.discord.RichPresenceBuilder;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;
import me.hypherionmc.simplerpclib.integrations.known.KnownServerHelpers;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.APIUtils;
import me.hypherionmc.simplerpclib.util.RPCContainer;

public class MultiPlayerSection
implements RPCContainer,
Serializable {
    @Path(value="enabled")
    @SpecComment(value="Enable/Disable the Multi Player Event")
    public boolean enabled = true;
    @Path(value="description")
    @SpecComment(value="The first line of text under the app name")
    public String description = "Playing on %servername% with %players% players";
    @Path(value="state")
    @SpecComment(value="The second line of text under the app name")
    public String state = "Playing online";
    @Path(value="largeImageKey")
    @SpecComment(value="The Asset ID of the image to display as the large image")
    public RandomArrayList<String> largeImageKey = RandomArrayList.of(new String[]{"mclogonew"});
    @Path(value="largeImageText")
    @SpecComment(value="The text that gets displayed when the large image is hovered")
    public String largeImageText = "It's Minecraft %mcver%, but modded";
    @Path(value="smallImageKey")
    @SpecComment(value="The Asset ID of the image to display as the small image")
    public RandomArrayList<String> smallImageKey = RandomArrayList.of(new String[]{"mclogo"});
    @Path(value="smallImageText")
    @SpecComment(value="The text that gets displayed when the small image is hovered")
    public String smallImageText = "%mods% mods installed";
    @Path(value="buttons")
    @SpecComment(value="The buttons to display on Discord")
    public List<RPCButton> buttonsList = new ArrayList<RPCButton>();

    @Override
    public RichPresenceBuilder buildPresence(RichPresenceCore core) {
        Dimension dim;
        Optional<Dimension> dimension;
        RichPresenceBuilder finalBuild;
        RichPresenceBuilder build = new RichPresenceBuilder().setDetails(core.getUtilHandler().parseVarsInternal(this.description, core.getClientConfig().variablesConfig)).setLargeImage(core.getUtilHandler().parseVarsInternal(this.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setLargeImageText(core.getUtilHandler().parseVarsInternal(this.largeImageText, core.getClientConfig().variablesConfig)).setSmallImage(core.getUtilHandler().parseVarsInternal(this.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setSmallImageText(core.getUtilHandler().parseVarsInternal(this.smallImageText, core.getClientConfig().variablesConfig)).setTimeStamp(OffsetDateTime.now()).setButtons(APIUtils.parseButtons(this.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setState(core.getUtilHandler().parseVarsInternal(this.state, core.getClientConfig().variablesConfig));
        build = LauncherUtils.getLauncherOverrides(build, core);
        if (core.getClientConfig().dimension_overrides.enabled) {
            finalBuild = build;
            dimension = APIUtils.findDimension(core.getClientConfig().dimension_overrides.dimensions, core.getUtilHandler().getWorld(), core.getUtilHandler().getBiome());
            if (dimension.isPresent()) {
                dim = dimension.get();
                if (dim.description != null && !dim.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVarsInternal(dim.description, core.getClientConfig().variablesConfig));
                }
                if (dim.state != null && !dim.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVarsInternal(dim.state, core.getClientConfig().variablesConfig));
                }
                if (dim.largeImageKey != null && !dim.largeImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setLargeImage(core.getUtilHandler().parseVarsInternal(dim.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (dim.largeImageText != null && !dim.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVarsInternal(dim.largeImageText, core.getClientConfig().variablesConfig));
                }
                if (dim.smallImageKey != null && !dim.smallImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setSmallImage(core.getUtilHandler().parseVarsInternal(dim.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (dim.smallImageText != null && !dim.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVarsInternal(dim.smallImageText, core.getClientConfig().variablesConfig));
                }
                if (!dim.buttonsList.isEmpty()) {
                    finalBuild.setButtons(APIUtils.parseButtons(dim.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig));
                }
                build = finalBuild;
            }
        }
        if (core.getClientConfig().general.discordid == 762726289341677668L && KnownServerHelpers.isKnownServer(core.getUtilHandler().parseVarsInternal("%serverip%", core.getClientConfig().variablesConfig))) {
            KnownServerHelpers.ServerInfo info = KnownServerHelpers.getKnownServer(core.getUtilHandler().parseVarsInternal("%serverip%", core.getClientConfig().variablesConfig));
            build.setLargeImage(info.serverIcon);
            build.setLargeImageText(core.getUtilHandler().parseVarsInternal("Playing on " + info.severName + " with %players% players", core.getClientConfig().variablesConfig));
        }
        if (core.getServerConfig() != null && core.getServerConfig().enabled && core.getServerConfig().multi_player.enabled) {
            if (core.getServerConfig().multi_player.description != null && !core.getServerConfig().multi_player.description.isEmpty()) {
                build.setDetails(core.getUtilHandler().parseVarsInternal(core.getServerConfig().multi_player.description, core.getClientConfig().variablesConfig));
            }
            if (core.getServerConfig().multi_player.largeImageKey != null && !core.getServerConfig().multi_player.largeImageKey.getNextRandom().orElse("").isEmpty()) {
                build.setLargeImage(core.getUtilHandler().parseVarsInternal(core.getServerConfig().multi_player.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
            }
            if (core.getServerConfig().multi_player.largeImageText != null && !core.getServerConfig().multi_player.largeImageText.isEmpty()) {
                build.setLargeImageText(core.getUtilHandler().parseVarsInternal(core.getServerConfig().multi_player.largeImageText, core.getClientConfig().variablesConfig));
            }
            if (core.getServerConfig().multi_player.smallImageKey != null && !core.getServerConfig().multi_player.smallImageKey.getNextRandom().orElse("").isEmpty()) {
                build.setSmallImage(core.getUtilHandler().parseVarsInternal(core.getServerConfig().multi_player.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
            }
            if (core.getServerConfig().multi_player.smallImageText != null && !core.getServerConfig().multi_player.smallImageText.isEmpty()) {
                build.setSmallImageText(core.getUtilHandler().parseVarsInternal(core.getServerConfig().multi_player.smallImageText, core.getClientConfig().variablesConfig));
            }
            if (core.getServerConfig().multi_player.state != null && !core.getServerConfig().multi_player.state.isEmpty()) {
                build.setState(core.getUtilHandler().parseVarsInternal(core.getServerConfig().multi_player.state, core.getClientConfig().variablesConfig));
            }
            if (core.getServerConfig().multi_player.buttonsList != null && !core.getServerConfig().multi_player.buttonsList.isEmpty()) {
                build.setButtons(APIUtils.parseButtons(core.getServerConfig().multi_player.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig));
            }
        }
        if (core.getServerConfig() != null && core.getServerConfig().enabled && core.getServerConfig().dimension_overrides.enabled) {
            finalBuild = build;
            dimension = APIUtils.findDimension(core.getServerConfig().dimension_overrides.dimensions, core.getUtilHandler().getWorld(), core.getUtilHandler().getBiome());
            if (dimension.isPresent()) {
                dim = dimension.get();
                if (dim.description != null && !dim.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVarsInternal(dim.description, core.getClientConfig().variablesConfig));
                }
                if (dim.state != null && !dim.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVarsInternal(dim.state, core.getClientConfig().variablesConfig));
                }
                if (dim.largeImageKey != null && !dim.largeImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setLargeImage(core.getUtilHandler().parseVarsInternal(dim.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (dim.largeImageText != null && !dim.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVarsInternal(dim.largeImageText, core.getClientConfig().variablesConfig));
                }
                if (dim.smallImageKey != null && !dim.smallImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setSmallImage(core.getUtilHandler().parseVarsInternal(dim.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (dim.smallImageText != null && !dim.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVarsInternal(dim.smallImageText, core.getClientConfig().variablesConfig));
                }
                if (!dim.buttonsList.isEmpty()) {
                    finalBuild.setButtons(APIUtils.parseButtons(dim.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig));
                }
                build = finalBuild;
            }
        }
        if (core.getServerEntriesConfig() != null && core.getServerEntriesConfig().enabled) {
            finalBuild = build;
            String address = core.getUtilHandler().parseVarsInternal("%serverip%", core.getClientConfig().variablesConfig);
            Optional<ServerEntry> serverEntry = APIUtils.findServer(core.getServerEntriesConfig().serverEntries, address);
            serverEntry.ifPresent(entry -> {
                if (entry.description != null && !entry.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVarsInternal(entry.description, core.getClientConfig().variablesConfig));
                }
                if (entry.largeImageKey != null && !entry.largeImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setLargeImage(core.getUtilHandler().parseVarsInternal(entry.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (entry.largeImageText != null && !entry.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVarsInternal(entry.largeImageText, core.getClientConfig().variablesConfig));
                }
                if (entry.smallImageKey != null && !entry.smallImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setSmallImage(core.getUtilHandler().parseVarsInternal(entry.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (entry.smallImageText != null && !entry.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVarsInternal(entry.smallImageText, core.getClientConfig().variablesConfig));
                }
                if (entry.state != null && !entry.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVarsInternal(entry.state, core.getClientConfig().variablesConfig));
                }
            });
            build = finalBuild;
        }
        return this.enabled ? build : null;
    }
}

