/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.handler;

import fr.atesab.customcursormod.common.handler.CommonButton;
import fr.atesab.customcursormod.common.handler.CommonMatrixStack;
import fr.atesab.customcursormod.common.handler.CommonShader;
import fr.atesab.customcursormod.common.handler.CommonSupplier;
import fr.atesab.customcursormod.common.handler.CommonText;
import fr.atesab.customcursormod.common.handler.CommonTextAppendable;
import fr.atesab.customcursormod.common.handler.TranslationCommonText;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public abstract class GuiUtils {
    public static final CommonSupplier<Void, GuiUtils> SUPPLIER = new CommonSupplier(true);
    private final TranslationCommonText YES = TranslationCommonText.create("cursormod.config.yes", new Object[0]);
    private final TranslationCommonText NO = TranslationCommonText.create("cursormod.config.no", new Object[0]);

    public static GuiUtils get() {
        return SUPPLIER.fetch();
    }

    public void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        this.drawScaledCustomSizeModalRect(x, y, u, v, uWidth, vHeight, width, height, tileWidth, tileHeight, 0xFFFFFF);
    }

    public void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight, int color) {
        this.drawScaledCustomSizeModalRect(x, y, u, v, uWidth, vHeight, width, height, tileWidth, tileHeight, color, false);
    }

    public abstract void drawScaledCustomSizeModalRect(int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8, float var9, float var10, int var11, boolean var12);

    public void drawGradientRect(CommonMatrixStack stack, float zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        this.drawGradientRect(stack, left, top, right, bottom, startColor, endColor, zLevel);
    }

    public void drawGradientRect(CommonMatrixStack stack, int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        this.drawGradientRect(stack, left, top, right, bottom, startColor, startColor, endColor, endColor, zLevel);
    }

    public abstract void drawGradientRect(CommonMatrixStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, float var10);

    public abstract int fontHeight();

    public abstract void setShaderColor(float var1, float var2, float var3, float var4);

    public void setShaderColor(float r, float g, float b) {
        this.setShaderColor(r, g, b, 1.0f);
    }

    public abstract void setShader(CommonShader var1);

    public CommonButton createBooleanButton(CommonText title, int xPosition, int yPosition, int width, int height, BooleanSupplier getter, Consumer<Boolean> setter) {
        boolean value = getter.getAsBoolean();
        CommonTextAppendable yes = title.copy().append(": ").append(this.YES);
        CommonTextAppendable no = title.copy().append(": ").append(this.NO);
        CommonTextAppendable msg = value ? yes : no;
        return CommonButton.create(msg, xPosition, yPosition, width, height, b -> {
            boolean v = !getter.getAsBoolean();
            setter.accept(v);
            b.setMessage(v ? yes : no);
        });
    }
}

