/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.config;

import fr.atesab.customcursormod.common.handler.ResourceLocationCommon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class CursorConfig {
    private int xHotSpot;
    private int yHotSpot;
    private String link;
    private long cursor = 0L;
    private GLFWImage glfwImage = GLFWImage.create();

    public static CursorConfig read(CursorConfigStore store, CursorConfig defaultConfig) {
        CursorConfig cursor = new CursorConfig();
        if (store == null) {
            cursor.xHotSpot = defaultConfig.xHotSpot;
            cursor.yHotSpot = defaultConfig.yHotSpot;
            cursor.link = defaultConfig.link;
        } else {
            cursor.xHotSpot = store.xHotSpot;
            cursor.yHotSpot = store.yHotSpot;
            cursor.link = store.link == null ? defaultConfig.link : store.link;
        }
        return cursor;
    }

    private CursorConfig() {
    }

    public CursorConfig(String link) {
        this(link, 0, 0);
    }

    public CursorConfig(String link, int xHotSpot, int yHotSpot) {
        this.xHotSpot = xHotSpot;
        this.yHotSpot = yHotSpot;
        this.link = link;
    }

    private void allocate() {
        this.readImage();
        if (this.cursor != 0L) {
            this.freeCursor();
        }
        this.cursor = GLFW.glfwCreateCursor((GLFWImage)this.glfwImage, (int)this.getxHotSpot(), (int)this.getyHotSpot());
    }

    public CursorConfig copy() {
        CursorConfig config = new CursorConfig(this.link, this.xHotSpot, this.yHotSpot);
        return config;
    }

    public void freeCursor() {
        if (this.isAllocate()) {
            GLFW.glfwDestroyCursor((long)this.cursor);
        }
    }

    public long getCursor() {
        if (this.cursor == 0L) {
            this.allocate();
        }
        return this.cursor;
    }

    public String getLink() {
        return this.link;
    }

    public InputStream getResource() {
        try {
            return this.getResourceLocation().openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceLocationCommon getResourceLocation() {
        return ResourceLocationCommon.create(this.link);
    }

    public int getxHotSpot() {
        return this.xHotSpot;
    }

    public int getyHotSpot() {
        return this.yHotSpot;
    }

    public boolean isAllocate() {
        return this.cursor != 0L;
    }

    private void readImage() {
        try {
            BufferedImage image = ImageIO.read(this.getResource());
            int w = image.getWidth();
            int h = image.getHeight();
            int[] pixels = new int[w * h];
            image.getRGB(0, 0, w, h, pixels, 0, w);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(w * h * 4));
            for (int y = h - 1; y >= 0; --y) {
                for (int x = 0; x < w; ++x) {
                    int pixel = pixels[(h - 1 - y) * w + x];
                    buffer.put((byte)(pixel & 0xFF));
                    buffer.put((byte)(pixel >> 8 & 0xFF));
                    buffer.put((byte)(pixel >> 16 & 0xFF));
                    buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            buffer.flip();
            this.glfwImage.pixels(buffer).width(w).height(h);
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void setLink(String link) {
        if (this.cursor != 0L) {
            this.allocate();
        }
        this.link = link;
    }

    public void setxHotSpot(int xHotSpot) {
        if (this.cursor != 0L) {
            this.allocate();
        }
        this.xHotSpot = xHotSpot;
    }

    public void setyHotSpot(int yHotSpot) {
        if (this.cursor != 0L) {
            this.allocate();
        }
        this.yHotSpot = yHotSpot;
    }

    public CursorConfigStore write() {
        return new CursorConfigStore(this);
    }

    public static class CursorConfigStore {
        int xHotSpot;
        int yHotSpot;
        String link;

        public CursorConfigStore(CursorConfig current) {
            this();
            this.xHotSpot = current.xHotSpot;
            this.yHotSpot = current.yHotSpot;
            this.link = current.link;
        }

        private CursorConfigStore() {
        }
    }
}

