/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.property.BooleanProperty;
import dev.ftb.mods.ftbteams.property.ColorProperty;
import dev.ftb.mods.ftbteams.property.IntProperty;
import dev.ftb.mods.ftbteams.property.StringProperty;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class TeamBase {
    public static final StringProperty DISPLAY_NAME = new StringProperty(new ResourceLocation("ftbteams", "display_name"), "", Pattern.compile(".{3,}"));
    public static final StringProperty DESCRIPTION = new StringProperty(new ResourceLocation("ftbteams", "description"), "");
    public static final ColorProperty COLOR = new ColorProperty(new ResourceLocation("ftbteams", "color"), Color4I.WHITE);
    public static final BooleanProperty FREE_TO_JOIN = new BooleanProperty(new ResourceLocation("ftbteams", "free_to_join"), false);
    public static final IntProperty MAX_MSG_HISTORY_SIZE = new IntProperty(new ResourceLocation("ftbteams", "max_msg_history_size"), 1000);
    UUID id = Util.f_137441_;
    public final TeamProperties properties;
    final Map<UUID, TeamRank> ranks = new HashMap<UUID, TeamRank>();
    CompoundTag extraData;
    protected final List<TeamMessage> messageHistory;

    public TeamBase() {
        this.properties = new TeamProperties();
        this.extraData = new CompoundTag();
        this.messageHistory = new LinkedList<TeamMessage>();
    }

    public abstract TeamType getType();

    public abstract boolean isValid();

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Team) {
            return this.id.equals(((Team)o).getId());
        }
        return false;
    }

    public String toString() {
        return this.getStringID();
    }

    public UUID getId() {
        return this.id;
    }

    public CompoundTag getExtraData() {
        return this.extraData;
    }

    public <T> T getProperty(TeamProperty<T> property) {
        return this.properties.get(property);
    }

    public <T> void setProperty(TeamProperty<T> property, T value) {
        this.properties.set(property, value);
        this.save();
    }

    public String getDisplayName() {
        return this.getProperty(DISPLAY_NAME);
    }

    public String getDescription() {
        return this.getProperty(DESCRIPTION);
    }

    public int getColor() {
        return this.getProperty(COLOR).rgb();
    }

    public boolean isFreeToJoin() {
        return this.getProperty(FREE_TO_JOIN);
    }

    public int getMaxMessageHistorySize() {
        return this.getProperty(MAX_MSG_HISTORY_SIZE);
    }

    public String getStringID() {
        String s = this.getDisplayName().replaceAll("\\W", "");
        return (s.length() > 50 ? s.substring(0, 50) : s) + "#" + this.getId().toString().substring(0, 8);
    }

    public Component getName() {
        MutableComponent text = Component.m_237113_((String)this.getDisplayName());
        if (this.getType().isPlayer()) {
            text.m_130940_(ChatFormatting.GRAY);
        } else if (this.getType().isServer()) {
            text.m_130940_(ChatFormatting.RED);
        } else {
            text.m_130940_(ChatFormatting.AQUA);
        }
        text.m_6270_(text.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams info " + this.getStringID())));
        return text;
    }

    public Component getColoredName() {
        MutableComponent text = Component.m_237113_((String)this.getDisplayName());
        text.m_130948_(this.getProperty(COLOR).toStyle().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams info " + this.getStringID())));
        return text;
    }

    public void save() {
    }

    public TeamRank getHighestRank(UUID playerId) {
        TeamRank rank = this.ranks.get(playerId);
        if (rank != null) {
            return rank;
        }
        if (this.getProperty(Team.FREE_TO_JOIN).booleanValue()) {
            return TeamRank.INVITED;
        }
        return TeamRank.NONE;
    }

    public boolean isMember(UUID uuid) {
        return this.getHighestRank(uuid).isMember();
    }

    public Map<UUID, TeamRank> getRanked(TeamRank rank) {
        if (rank == TeamRank.NONE) {
            return this.ranks;
        }
        HashMap<UUID, TeamRank> map = new HashMap<UUID, TeamRank>();
        for (Map.Entry<UUID, TeamRank> entry : this.ranks.entrySet()) {
            if (!entry.getValue().is(rank)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public Set<UUID> getMembers() {
        return this.getRanked(TeamRank.MEMBER).keySet();
    }

    public boolean isAlly(UUID profile) {
        return this.getHighestRank(profile).isAlly();
    }

    public boolean isOfficer(UUID profile) {
        return this.getHighestRank(profile).isOfficer();
    }

    public boolean isInvited(UUID profile) {
        return this.getHighestRank(profile).isInvited();
    }

    public void addMessage(TeamMessage message) {
        this.addMessages(List.of(message));
    }

    public void addMessages(Collection<TeamMessage> messages) {
        this.messageHistory.addAll(messages);
        while (this.messageHistory.size() > this.getMaxMessageHistorySize()) {
            this.messageHistory.remove(0);
        }
        this.save();
    }

    public List<TeamMessage> getMessageHistory() {
        return this.messageHistory;
    }
}

