/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.DeferredInventoryDetection;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class FTBQuestsInventoryListener
implements ContainerListener {
    public final ServerPlayer player;

    public FTBQuestsInventoryListener(ServerPlayer p) {
        this.player = p;
    }

    public static void detect(ServerPlayer player, ItemStack craftedItem, long sourceTask) {
        List<Task> tasksToCheck;
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || PlayerHooks.isFake((Player)player)) {
            return;
        }
        TeamData data = file.getNullableTeamData(FTBTeamsAPI.getPlayerTeamID((UUID)player.m_20148_()));
        if (data == null || data.isLocked()) {
            return;
        }
        List<Task> list = tasksToCheck = craftedItem.m_41619_() ? file.getSubmitTasks() : file.getCraftingTasks();
        if (!tasksToCheck.isEmpty()) {
            file.withPlayerContext(player, () -> {
                for (Task task : tasksToCheck) {
                    if (task.id == sourceTask || !data.canStartTasks(task.quest)) continue;
                    task.submitTask(data, player, craftedItem);
                }
            });
        }
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    public void m_7934_(AbstractContainerMenu container, int index, ItemStack stack) {
        int slotNum;
        if (!stack.m_41619_() && container.m_38853_((int)index).f_40218_ == this.player.m_150109_() && (slotNum = container.m_38853_(index).m_150661_()) >= 0 && slotNum < this.player.m_150109_().f_35974_.size()) {
            int delay = Mth.m_14045_((int)ServerQuestFile.INSTANCE.detectionDelay, (int)0, (int)200);
            if (delay == 0) {
                FTBQuestsInventoryListener.detect(this.player, ItemStack.f_41583_, 0L);
            } else {
                DeferredInventoryDetection.scheduleInventoryCheck(this.player, delay);
            }
        }
    }
}

