/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.architectury.event.EventActor;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.net.DisplayCompletionToastMessage;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.DependencyDepthException;
import dev.ftb.mods.ftbquests.quest.DependencyLoopException;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Chapter
extends QuestObject {
    public final QuestFile file;
    public ChapterGroup group;
    public String filename;
    private final List<Quest> quests;
    private final List<QuestLink> questLinks;
    public final List<String> subtitle;
    public boolean alwaysInvisible;
    public String defaultQuestShape;
    public final List<ChapterImage> images;
    public boolean defaultHideDependencyLines;
    public int defaultMinWidth = 0;
    private ProgressionMode progressionMode;
    private boolean hideQuestDetailsUntilStartable;
    private boolean hideQuestUntilDepsVisible;

    public Chapter(QuestFile f, ChapterGroup g) {
        this.file = f;
        this.group = g;
        this.filename = "";
        this.quests = new ArrayList<Quest>();
        this.questLinks = new ArrayList<QuestLink>();
        this.subtitle = new ArrayList<String>(0);
        this.alwaysInvisible = false;
        this.defaultQuestShape = "";
        this.images = new ArrayList<ChapterImage>();
        this.defaultHideDependencyLines = false;
        this.progressionMode = ProgressionMode.DEFAULT;
        this.hideQuestUntilDepsVisible = false;
        this.hideQuestDetailsUntilStartable = false;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.group.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        ListTag list;
        nbt.m_128359_("filename", this.filename);
        super.writeData(nbt);
        if (!this.subtitle.isEmpty()) {
            list = new ListTag();
            for (String v : this.subtitle) {
                list.add((Object)StringTag.m_129297_((String)v));
            }
            nbt.m_128365_("subtitle", (Tag)list);
        }
        if (this.alwaysInvisible) {
            nbt.m_128379_("always_invisible", true);
        }
        nbt.m_128359_("default_quest_shape", this.defaultQuestShape);
        nbt.m_128379_("default_hide_dependency_lines", this.defaultHideDependencyLines);
        if (!this.images.isEmpty()) {
            list = new ListTag();
            for (ChapterImage image : this.images) {
                SNBTCompoundTag nbt1 = new SNBTCompoundTag();
                image.writeData((CompoundTag)nbt1);
                list.add((Object)nbt1);
            }
            nbt.m_128365_("images", (Tag)list);
        }
        if (this.defaultMinWidth > 0) {
            nbt.m_128405_("default_min_width", this.defaultMinWidth);
        }
        if (this.progressionMode != ProgressionMode.DEFAULT) {
            nbt.m_128359_("progression_mode", this.progressionMode.getId());
        }
        if (this.hideQuestDetailsUntilStartable) {
            nbt.m_128379_("hide_quest_details_until_startable", true);
        }
        if (this.hideQuestUntilDepsVisible) {
            nbt.m_128379_("hide_quest_until_deps_visible", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        this.filename = nbt.m_128461_("filename");
        super.readData(nbt);
        this.subtitle.clear();
        ListTag subtitleNBT = nbt.m_128437_("subtitle", 8);
        for (int i = 0; i < subtitleNBT.size(); ++i) {
            this.subtitle.add(subtitleNBT.m_128778_(i));
        }
        this.alwaysInvisible = nbt.m_128471_("always_invisible");
        this.defaultQuestShape = nbt.m_128461_("default_quest_shape");
        if (this.defaultQuestShape.equals("default")) {
            this.defaultQuestShape = "";
        }
        this.defaultHideDependencyLines = nbt.m_128471_("default_hide_dependency_lines");
        ListTag imgs = nbt.m_128437_("images", 10);
        this.images.clear();
        for (int i = 0; i < imgs.size(); ++i) {
            ChapterImage image = new ChapterImage(this);
            image.readData(imgs.m_128728_(i));
            this.images.add(image);
        }
        this.defaultMinWidth = nbt.m_128451_("default_min_width");
        this.progressionMode = (ProgressionMode)((Object)ProgressionMode.NAME_MAP.get(nbt.m_128461_("progression_mode")));
        this.hideQuestDetailsUntilStartable = nbt.m_128471_("hide_quest_details_until_startable");
        this.hideQuestUntilDepsVisible = nbt.m_128471_("hide_quest_until_deps_visible");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.filename, Short.MAX_VALUE);
        NetUtils.writeStrings(buffer, this.subtitle);
        buffer.writeBoolean(this.alwaysInvisible);
        buffer.m_130072_(this.defaultQuestShape, Short.MAX_VALUE);
        NetUtils.write(buffer, this.images, (d, img) -> img.writeNetData((FriendlyByteBuf)d));
        buffer.writeBoolean(this.defaultHideDependencyLines);
        buffer.writeInt(this.defaultMinWidth);
        ProgressionMode.NAME_MAP.write(buffer, (Object)this.progressionMode);
        buffer.writeBoolean(this.hideQuestDetailsUntilStartable);
        buffer.writeBoolean(this.hideQuestUntilDepsVisible);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.filename = buffer.m_130136_(Short.MAX_VALUE);
        NetUtils.readStrings(buffer, this.subtitle);
        this.alwaysInvisible = buffer.readBoolean();
        this.defaultQuestShape = buffer.m_130136_(Short.MAX_VALUE);
        NetUtils.read(buffer, this.images, d -> {
            ChapterImage image = new ChapterImage(this);
            image.readNetData((FriendlyByteBuf)d);
            return image;
        });
        this.defaultHideDependencyLines = buffer.readBoolean();
        this.defaultMinWidth = buffer.readInt();
        this.progressionMode = (ProgressionMode)((Object)ProgressionMode.NAME_MAP.read(buffer));
        this.hideQuestDetailsUntilStartable = buffer.readBoolean();
        this.hideQuestUntilDepsVisible = buffer.readBoolean();
    }

    public int getIndex() {
        return this.group.chapters.indexOf(this);
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        if (this.alwaysInvisible) {
            return 100;
        }
        if (this.quests.isEmpty()) {
            return 100;
        }
        int progress = 0;
        int count = 0;
        for (Quest quest : this.quests) {
            if (quest.isProgressionIgnored()) continue;
            progress += data.getRelativeProgress(quest);
            ++count;
        }
        if (count <= 0) {
            return 100;
        }
        return Chapter.getRelativeProgressFromChildren(progress, count);
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.teamData.setStarted(this.id, data.time);
        ((EventActor)ObjectStartedEvent.CHAPTER.invoker()).act((Object)new ObjectStartedEvent.ChapterEvent(data.withObject(this)));
        if (!data.teamData.isStarted(this.file)) {
            this.file.onStarted(data.withObject(this.file));
        }
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.teamData.setCompleted(this.id, data.time);
        ((EventActor)ObjectCompletedEvent.CHAPTER.invoker()).act((Object)new ObjectCompletedEvent.ChapterEvent(data.withObject(this)));
        if (!this.disableToast) {
            for (ServerPlayer player : data.notifiedPlayers) {
                new DisplayCompletionToastMessage(this.id).sendTo(player);
            }
        }
        for (ChapterGroup g : this.file.chapterGroups) {
            for (Chapter chapter : g.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.hasDependency(this)) continue;
                    data.teamData.checkAutoCompletion(quest);
                }
            }
        }
        if (this.group.isCompletedRaw(data.teamData)) {
            this.group.onCompleted(data.withObject(this.group));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.unnamed");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Quest quest : this.quests) {
            list.add(quest.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.group.chapters.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Quest quest : this.quests) {
            quest.deleteChildren();
            quest.invalid = true;
        }
        this.quests.clear();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            String s;
            this.filename = s = Chapter.titleToID(this.title).orElse(this.toString());
            Set existingNames = this.group.file.chapterGroups.stream().flatMap(g -> g.chapters.stream()).map(ch -> ch.filename).collect(Collectors.toSet());
            int i = 2;
            while (existingNames.contains(this.filename)) {
                this.filename = s + "_" + i;
                ++i;
            }
        }
        this.group.chapters.add(this);
        if (!this.quests.isEmpty()) {
            ArrayList<Quest> l = new ArrayList<Quest>(this.quests);
            this.quests.clear();
            for (Quest quest : l) {
                quest.onCreated();
            }
        }
    }

    public String getFilename() {
        if (this.filename.isEmpty()) {
            this.filename = Chapter.getCodeString(this);
        }
        return this.filename;
    }

    @Override
    public String getPath() {
        return "chapters/" + this.getFilename() + ".snbt";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("subtitle", this.subtitle, (ConfigValue)new StringConfig(null), (Object)"");
        config.addBool("always_invisible", this.alwaysInvisible, v -> {
            this.alwaysInvisible = v;
        }, false);
        config.addEnum("default_quest_shape", (Object)(this.defaultQuestShape.isEmpty() ? "default" : this.defaultQuestShape), v -> {
            this.defaultQuestShape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addBool("default_hide_dependency_lines", this.defaultHideDependencyLines, v -> {
            this.defaultHideDependencyLines = v;
        }, false);
        config.addInt("default_min_width", this.defaultMinWidth, v -> {
            this.defaultMinWidth = v;
        }, 0, 0, 3000);
        config.addEnum("progression_mode", (Object)this.progressionMode, v -> {
            this.progressionMode = v;
        }, ProgressionMode.NAME_MAP);
        config.addBool("hide_quest_details_until_startable", this.hideQuestDetailsUntilStartable, v -> {
            this.hideQuestDetailsUntilStartable = v;
        }, false);
        config.addBool("hide_quest_until_deps_visible", this.hideQuestUntilDepsVisible, v -> {
            this.hideQuestUntilDepsVisible = v;
        }, false);
    }

    @Override
    public boolean isVisible(TeamData data) {
        if (this.alwaysInvisible) {
            return false;
        }
        return this.hasVisibleQuest(data);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Quest quest : this.quests) {
            quest.clearCachedData();
        }
    }

    @Override
    protected void verifyDependenciesInternal(long original, int depth) {
        if (depth >= 1000) {
            throw new DependencyDepthException(this);
        }
        for (Quest quest : this.quests) {
            if (quest.id == original) {
                throw new DependencyLoopException(this);
            }
            quest.verifyDependenciesInternal(original, depth + 1);
        }
    }

    public boolean hasGroup() {
        return !this.group.isDefaultGroup();
    }

    public String getDefaultQuestShape() {
        return this.defaultQuestShape.isEmpty() ? this.file.getDefaultQuestShape() : this.defaultQuestShape;
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.quests;
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        for (Quest quest : this.quests) {
            if (!teamData.hasUnclaimedRewards(player, quest)) continue;
            return true;
        }
        return false;
    }

    public ProgressionMode getProgressionMode() {
        return this.progressionMode == ProgressionMode.DEFAULT ? this.file.getProgressionMode() : this.progressionMode;
    }

    public boolean hideQuestDetailsUntilStartable() {
        return this.hideQuestDetailsUntilStartable;
    }

    public boolean hideQuestUntilDepsVisible() {
        return this.hideQuestUntilDepsVisible;
    }

    public boolean hasVisibleQuestLazy() {
        return !this.quests.isEmpty() || !this.questLinks.isEmpty();
    }

    public boolean hasVisibleQuest(TeamData data) {
        for (QuestObject object : this.getAllQuests()) {
            if (!object.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public List<QuestObject> getAllQuests() {
        ArrayList<QuestObject> list = new ArrayList<QuestObject>();
        list.addAll(this.quests);
        list.addAll(this.questLinks);
        return list;
    }

    public List<Quest> getQuests() {
        return this.quests;
    }

    public List<QuestLink> getQuestLinks() {
        return this.questLinks;
    }
}

