/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.ftb.mods.ftblibrary.icon.AtlasSpriteIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.RenderUtil;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.EnergyTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

public class TaskScreenRenderer
implements BlockEntityRenderer<TaskScreenBlockEntity> {
    public static final ResourceLocation INPUT_ONLY_TEXTURE = new ResourceLocation("ftbquests", "tasks/input_only");
    public static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "tasks/tank");
    public static final ResourceLocation FE_ENERGY_EMPTY_TEXTURE = new ResourceLocation("ftbquests", "tasks/fe_empty");
    public static final ResourceLocation FE_ENERGY_FULL_TEXTURE = new ResourceLocation("ftbquests", "tasks/fe_full");
    public static final ResourceLocation TR_ENERGY_EMPTY_TEXTURE = new ResourceLocation("ftbquests", "tasks/ic2_empty");
    public static final ResourceLocation TR_ENERGY_FULL_TEXTURE = new ResourceLocation("ftbquests", "tasks/ic2_full");
    private final BlockEntityRendererProvider.Context context;

    public TaskScreenRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public int m_142163_() {
        return 64;
    }

    public boolean shouldRender(TaskScreenBlockEntity blockEntity, Vec3 vec3) {
        return super.m_142756_((BlockEntity)blockEntity, vec3);
    }

    public void render(TaskScreenBlockEntity taskScreen, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay) {
        Block block;
        if (!ClientQuestFile.exists() || !((block = taskScreen.m_58900_().m_60734_()) instanceof TaskScreenBlock)) {
            return;
        }
        TaskScreenBlock taskScreenBlock = (TaskScreenBlock)block;
        TeamData data = ClientQuestFile.INSTANCE.getNullableTeamData(taskScreen.getTeamId());
        Task task = taskScreen.getTask();
        if (task == null || data == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float rotation = ((Direction)taskScreen.m_58900_().m_61143_((Property)WallSignBlock.f_58064_)).m_122435_() + 180.0f;
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        int size = taskScreenBlock.getSize() / 2;
        poseStack.m_85837_((double)(-size), (double)((float)(-size) * 2.0f), (double)-0.02f);
        poseStack.m_85841_((float)size * 2.0f + 1.0f, (float)size * 2.0f + 1.0f, 1.0f);
        Font font = this.context.m_173586_();
        double iconY = 0.5;
        MutableComponent top1 = taskScreen.isInputOnly() ? Component.m_237119_() : task.quest.getTitle();
        MutableComponent top2 = taskScreen.isInputOnly() ? Component.m_237119_() : task.getTitle();
        this.drawString(taskScreen, font, poseStack, (Component)top1, 0.02, 0.15);
        if (!top2.equals(Component.m_237119_())) {
            this.drawString(taskScreen, font, poseStack, (Component)top2, 0.17, 0.07);
            iconY = 0.54;
        }
        if (!taskScreen.isInputOnly() && !task.hideProgressNumbers()) {
            long progress = data.getProgress(task);
            ChatFormatting col = progress == 0L ? ChatFormatting.GOLD : (progress < task.getMaxProgress() ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
            MutableComponent txt = Component.m_237113_((String)(task.formatProgress(data, progress) + " / " + task.formatMaxProgress())).m_130940_(col);
            this.drawString(taskScreen, font, poseStack, (Component)txt, 0.83, 0.15);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, iconY, -0.01);
        poseStack.m_85841_(taskScreen.isInputOnly() ? 0.5f : 0.45f, taskScreen.isInputOnly() ? 0.5f : 0.45f, 0.2f * (float)size);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        if (taskScreen.isInputOnly() && !taskScreen.getInputModeIcon().m_41619_()) {
            this.drawTaskIcon(taskScreen, data, ItemIcon.getItemIcon((ItemStack)taskScreen.getInputModeIcon()), poseStack, multiBufferSource);
        } else {
            this.drawTaskIcon(taskScreen, data, task.getIcon(), poseStack, multiBufferSource);
        }
        poseStack.m_85849_();
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)InventoryMenu.f_39692_));
        float[] f = taskScreen.getFakeTextureUV();
        if (f != null && f.length == 4) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
            poseStack.m_85837_(0.0, 0.0, (double)0.01f);
            RenderUtil.create(poseStack, vertexConsumer, 0.0f, 0.0f).withUV(f[0], f[1], f[2], f[3]).draw();
            poseStack.m_85849_();
        }
        if (taskScreen.isInputOnly() && FTBQuestsClientEventHandler.inputOnlySprite != null) {
            TextureAtlasSprite s = FTBQuestsClientEventHandler.inputOnlySprite;
            poseStack.m_85836_();
            poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
            RenderUtil.create(poseStack, vertexConsumer, 0.0f, 0.0f).withUV(s.m_118409_(), s.m_118411_(), s.m_118410_(), s.m_118412_()).draw();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    /*
     * Unable to fully structure code
     */
    private void drawTaskIcon(TaskScreenBlockEntity taskScreen, TeamData data, Icon icon, PoseStack poseStack, MultiBufferSource buffer) {
        vertexConsumer = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)InventoryMenu.f_39692_));
        task = taskScreen.getTask();
        progress = data.getProgress(task);
        poseStack.m_85836_();
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        if (icon instanceof IconAnimation) {
            anim = (IconAnimation)icon;
            icon = (Icon)anim.list.get((int)(System.currentTimeMillis() / 1000L % (long)anim.list.size()));
        }
        if (!(task instanceof FluidTask) || !((var15_10 = (fluidTask = (FluidTask)task).getIcon()) instanceof AtlasSpriteIcon)) ** GOTO lbl-1000
        as = (AtlasSpriteIcon)var15_10;
        if (FTBQuestsClientEventHandler.tankSprite != null) {
            sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(as.id);
            if (progress > 0L) {
                heightInterpolated = 16.0f * (float)((double)progress / (double)task.getMaxProgress());
                RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withColor(FluidStackHooks.getColor((Fluid)fluidTask.fluid) | -16777216).withSize(16.0f, heightInterpolated).withUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118393_((double)heightInterpolated)).draw();
            }
            s = FTBQuestsClientEventHandler.tankSprite;
            poseStack.m_85837_(0.0, 0.0, -0.05000000074505806);
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(s.m_118409_(), s.m_118411_(), s.m_118410_(), s.m_118412_()).draw();
        } else if (task instanceof EnergyTask) {
            energyTask = (EnergyTask)task;
            empty = energyTask.getClientData().getEmptyTexture();
            full = energyTask.getClientData().getFullTexture();
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(empty.m_118409_(), empty.m_118411_(), empty.m_118410_(), empty.m_118412_()).draw();
            if (progress > 0L) {
                heightInterpolated = 16.0f * (float)((double)progress / (double)task.getMaxProgress());
                poseStack.m_85837_(0.0, 0.0, -0.05000000074505806);
                RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withSize(16.0f, heightInterpolated).withUV(full.m_118409_(), full.m_118411_(), full.m_118410_(), full.m_118393_((double)heightInterpolated)).draw();
            }
        } else if (icon instanceof ItemIcon) {
            itemIcon = (ItemIcon)icon;
            poseStack.m_85841_(16.0f, 16.0f, 16.0f);
            Minecraft.m_91087_().m_91291_().m_174269_(itemIcon.getStack(), ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, poseStack, buffer, 0);
        } else if (icon instanceof AtlasSpriteIcon) {
            spriteIcon = (AtlasSpriteIcon)icon;
            sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(spriteIcon.id);
            RenderUtil.create(poseStack, vertexConsumer, -8.0f, -8.0f).withUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_()).draw();
        }
        poseStack.m_85849_();
    }

    private void drawString(TaskScreenBlockEntity taskScreen, Font font, PoseStack poseStack, Component text, double y, double size) {
        if (!text.equals(Component.m_237119_())) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, y, 0.0);
            int len = font.m_92852_((FormattedText)text);
            float scale = (float)(size / 9.0);
            double width = (float)len * scale;
            if (width > 1.0) {
                scale = (float)((double)scale / width);
                width = 1.0;
            }
            if (width > 0.9) {
                scale = (float)((double)scale * 0.9);
            }
            poseStack.m_85841_(scale, scale, 1.0f);
            if (taskScreen.isTextShadow()) {
                font.m_92763_(poseStack, text, (float)(-len) / 2.0f, 0.0f, -2565928);
            } else {
                font.m_92889_(poseStack, text, (float)(-len) / 2.0f, 0.0f, -2565928);
            }
            poseStack.m_85849_();
        }
    }
}

