/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests;

import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.utils.EnvExecutor;
import dev.ftb.mods.ftbquests.FTBQuestsCommon;
import dev.ftb.mods.ftbquests.FTBQuestsEventHandler;
import dev.ftb.mods.ftbquests.FTBQuestsNetCommon;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsNetClient;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBQuests {
    public static final String MOD_ID = "ftbquests";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Quests");
    public static FTBQuests instance;
    public static FTBQuestsCommon PROXY;
    public static FTBQuestsNetCommon NET_PROXY;
    public static final CreativeModeTab ITEM_GROUP;
    private static RecipeModHelper recipeModHelper;
    private static final RecipeModHelper NO_OP_HELPER;

    public FTBQuests() {
        TaskTypes.init();
        RewardTypes.init();
        FTBQuestsNetHandler.init();
        PROXY = (FTBQuestsCommon)EnvExecutor.getEnvSpecific(() -> FTBQuestsClient::new, () -> FTBQuestsCommon::new);
        NET_PROXY = (FTBQuestsNetCommon)EnvExecutor.getEnvSpecific(() -> FTBQuestsNetClient::new, () -> FTBQuestsNetCommon::new);
        new FTBQuestsEventHandler().init();
        PROXY.init();
        if (!Platform.isModLoaded((String)"ftbxmodcompat")) {
            LOGGER.info("Mod [FTB XMod Compat] not detected. Install it if you want FTB Quests integration with KubeJS, JEI/REI and/or Game Stages");
        }
    }

    public static RecipeModHelper getRecipeModHelper() {
        return Objects.requireNonNullElse(recipeModHelper, NO_OP_HELPER);
    }

    public static void setRecipeModHelper(RecipeModHelper recipeModHelper) {
        if (FTBQuests.recipeModHelper != null) {
            throw new IllegalStateException("recipe mod helper has already been initialised!");
        }
        FTBQuests.recipeModHelper = recipeModHelper;
    }

    public void setup() {
    }

    static {
        ITEM_GROUP = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation(MOD_ID, MOD_ID), () -> new ItemStack((ItemLike)FTBQuestsItems.BOOK.get()));
        NO_OP_HELPER = new RecipeModHelper.NoOp();
    }
}

