/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class AtlasSpriteIcon
extends Icon {
    public final ResourceLocation id;
    public Color4I color;

    AtlasSpriteIcon(ResourceLocation n) {
        this.id = n;
        this.color = Color4I.WHITE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack matrixStack, int x, int y, int w, int h) {
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(this.id);
        if (sprite == null) {
            return;
        }
        Matrix4f m = matrixStack.m_85850_().m_85861_();
        int r = this.color.redi();
        int g = this.color.greeni();
        int b = this.color.bluei();
        int a = this.color.alphai();
        float minU = sprite.m_118409_();
        float minV = sprite.m_118411_();
        float maxU = sprite.m_118410_();
        float maxV = sprite.m_118412_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)sprite.m_118414_().m_117963_());
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, minV).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public boolean hasPixelBuffer() {
        return true;
    }

    @Override
    @Nullable
    public PixelBuffer createPixelBuffer() {
        try {
            return PixelBuffer.from(((Resource)Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(this.id.m_135827_(), "textures/" + this.id.m_135815_() + ".png")).orElseThrow()).m_215507_());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public AtlasSpriteIcon copy() {
        return new AtlasSpriteIcon(this.id);
    }

    @Override
    public AtlasSpriteIcon withColor(Color4I color) {
        AtlasSpriteIcon icon = this.copy();
        icon.color = color;
        return icon;
    }

    @Override
    public AtlasSpriteIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }
}

