/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.netherportalfix.ReturnPortal;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalForcer;
import org.jetbrains.annotations.Nullable;

public class ReturnPortalManager {
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String RETURN_PORTAL_LIST = "ReturnPortalList";
    private static final String RETURN_PORTAL_UID = "UID";
    private static final String FROM_DIM = "FromDim";
    private static final String FROM_POS = "FromPos";
    private static final String TO_MIN_CORNER = "ToMinCorner";
    private static final String TO_AXIS_1_SIZE = "ToAxis1Size";
    private static final String TO_AXIS_2_SIZE = "ToAxis2Size";

    public static BlockUtil.FoundRectangle findPortalAt(Player player, ResourceKey<Level> dim, BlockPos pos) {
        ServerLevel fromWorld;
        MinecraftServer server = player.f_19853_.m_7654_();
        if (server != null && (fromWorld = server.m_129880_(dim)) != null) {
            PortalForcer portalForcer = fromWorld.m_8871_();
            return portalForcer.m_192985_(pos, false, fromWorld.m_6857_()).orElse(null);
        }
        return null;
    }

    public static ListTag getPlayerPortalList(Player player) {
        CompoundTag data = Balm.getHooks().getPersistentData(player);
        ListTag list = data.m_128437_(RETURN_PORTAL_LIST, 10);
        data.m_128365_(RETURN_PORTAL_LIST, (Tag)list);
        return list;
    }

    @Nullable
    public static ReturnPortal findReturnPortal(ServerPlayer player, ResourceKey<Level> fromDim, BlockPos fromPos) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Player)player);
        for (Tag entry : portalList) {
            BlockPos portalTrigger;
            CompoundTag portal = (CompoundTag)entry;
            ResourceKey entryFromDim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(portal.m_128461_(FROM_DIM)));
            if (entryFromDim != fromDim || !((portalTrigger = BlockPos.m_122022_((long)portal.m_128454_(FROM_POS))).m_123331_((Vec3i)fromPos) <= 16.0)) continue;
            UUID uid = portal.m_128403_(RETURN_PORTAL_UID) ? portal.m_128342_(RETURN_PORTAL_UID) : UUID.randomUUID();
            BlockPos minCorner = BlockPos.m_122022_((long)portal.m_128454_(TO_MIN_CORNER));
            int axis1Size = portal.m_128451_(TO_AXIS_1_SIZE);
            int axis2Size = portal.m_128451_(TO_AXIS_2_SIZE);
            return new ReturnPortal(uid, new BlockUtil.FoundRectangle(minCorner, axis1Size, axis2Size));
        }
        return null;
    }

    public static void storeReturnPortal(ServerPlayer player, ResourceKey<Level> fromDim, BlockPos fromPos, BlockUtil.FoundRectangle toPortal) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Player)player);
        ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal(player, fromDim, fromPos);
        if (returnPortal != null) {
            ReturnPortalManager.removeReturnPortal(player, returnPortal);
        }
        CompoundTag portalCompound = new CompoundTag();
        portalCompound.m_128362_(RETURN_PORTAL_UID, UUID.randomUUID());
        portalCompound.m_128359_(FROM_DIM, String.valueOf(fromDim.m_135782_()));
        portalCompound.m_128356_(FROM_POS, fromPos.m_121878_());
        portalCompound.m_128356_(TO_MIN_CORNER, toPortal.f_124348_.m_121878_());
        portalCompound.m_128405_(TO_AXIS_1_SIZE, toPortal.f_124349_);
        portalCompound.m_128405_(TO_AXIS_2_SIZE, toPortal.f_124350_);
        portalList.add((Object)portalCompound);
    }

    public static void removeReturnPortal(ServerPlayer player, ReturnPortal portal) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Player)player);
        for (int i = 0; i < portalList.size(); ++i) {
            CompoundTag entry = (CompoundTag)portalList.get(i);
            if (!entry.m_128403_(RETURN_PORTAL_UID) || !entry.m_128342_(RETURN_PORTAL_UID).equals(portal.getUid())) continue;
            portalList.remove(i);
            break;
        }
    }
}

