/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.recipes.IBrewingInventory;
import lekavar.lma.drinkbeer.registries.RecipeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class BrewingRecipe
implements Recipe<IBrewingInventory> {
    public static final int INPUT_SIZE = 4;
    private final ResourceLocation id;
    private final NonNullList<Ingredient> input;
    private final ItemStack cup;
    private final int brewingTime;
    private final ItemStack result;

    public BrewingRecipe(ResourceLocation id, NonNullList<Ingredient> input, ItemStack cup, int brewingTime, ItemStack result) {
        this.id = id;
        this.input = input;
        this.cup = cup;
        this.brewingTime = brewingTime;
        this.result = result;
    }

    @Deprecated
    public NonNullList<Ingredient> getIngredient() {
        NonNullList result = NonNullList.m_122779_();
        result.addAll(this.input);
        return result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList result = NonNullList.m_122779_();
        result.addAll(this.input);
        return result;
    }

    @Deprecated
    public ItemStack geBeerCup() {
        return this.cup.m_41777_();
    }

    public ItemStack getBeerCup() {
        return this.cup.m_41777_();
    }

    public boolean matches(IBrewingInventory pContainer, Level pLevel) {
        ArrayList testTarget = Lists.newArrayList(this.input);
        List<ItemStack> tested = pContainer.getIngredients();
        if (tested.size() < 4) {
            return false;
        }
        for (ItemStack itemStack : tested) {
            int i = this.getLatestMatched(testTarget, itemStack);
            if (i == -1) {
                return false;
            }
            testTarget.remove(i);
        }
        return testTarget.isEmpty();
    }

    private int getLatestMatched(List<Ingredient> testTarget, ItemStack tested) {
        for (int i = 0; i < testTarget.size(); ++i) {
            if (!testTarget.get(i).test(tested)) continue;
            return i;
        }
        return -1;
    }

    public ItemStack assemble(IBrewingInventory inventory) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.RECIPE_SERIALIZER_BREWING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.RECIPE_TYPE_BREWING.get();
    }

    public int getRequiredCupCount() {
        return this.cup.m_41613_();
    }

    public boolean isCupQualified(IBrewingInventory inventory) {
        return inventory.getCup().m_41720_() == this.cup.m_41720_() && inventory.getCup().m_41613_() >= this.cup.m_41613_();
    }

    public int getBrewingTime() {
        return this.brewingTime;
    }

    public static class Serializer
    implements RecipeSerializer<BrewingRecipe> {
        public BrewingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            ItemStack cup = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"cup"), (boolean)true);
            int brewing_time = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"brewing_time");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"), (boolean)true);
            return new BrewingRecipe(resourceLocation, ingredients, cup, brewing_time, result);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray jsonArray) {
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        @Nullable
        public BrewingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf packetBuffer) {
            int i = packetBuffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)packetBuffer));
            }
            ItemStack cup = packetBuffer.m_130267_();
            int brewingTime = packetBuffer.m_130242_();
            ItemStack result = packetBuffer.m_130267_();
            return new BrewingRecipe(resourceLocation, (NonNullList<Ingredient>)ingredients, cup, brewingTime, result);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, BrewingRecipe brewingRecipe) {
            packetBuffer.m_130130_(brewingRecipe.input.size());
            for (Ingredient ingredient : brewingRecipe.input) {
                ingredient.m_43923_(packetBuffer);
            }
            packetBuffer.m_130055_(brewingRecipe.cup);
            packetBuffer.m_130130_(brewingRecipe.brewingTime);
            packetBuffer.m_130055_(brewingRecipe.result);
        }
    }
}

