/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.compat.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lekavar.lma.drinkbeer.recipes.BrewingRecipe;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class JEIBrewingRecipe
implements IRecipeCategory<BrewingRecipe> {
    public static final RecipeType<BrewingRecipe> TYPE = RecipeType.create((String)"drinkbeer", (String)"brewing", BrewingRecipe.class);
    private static final String DRINK_BEER_YELLOW = "#F4D223";
    private static final String NIGHT_HOWL_CUP_HEX_COLOR = "#C69B82";
    private static final String PUMPKIN_DRINK_CUP_HEX_COLOR = "#AC6132";
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public JEIBrewingRecipe(IGuiHelper helper) {
        this.guiHelper = helper;
        this.background = helper.createDrawable(new ResourceLocation("drinkbeer", "textures/gui/jei/brewing_gui.png"), 0, 0, 175, 69);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ItemRegistry.BEER_MUG.get()));
    }

    public RecipeType<BrewingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"drinkbeer.jei.title.brewing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BrewingRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 28, 16);
        slotBuilder.addIngredients((Ingredient)ingredients.get(0));
        slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 46, 16);
        slotBuilder.addIngredients((Ingredient)ingredients.get(1));
        slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 28, 34);
        slotBuilder.addIngredients((Ingredient)ingredients.get(2));
        slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 46, 34);
        slotBuilder.addIngredients((Ingredient)ingredients.get(3));
        slotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 24);
        slotBuilder.addItemStack(recipe.m_8043_());
        builder.moveRecipeTransferButton(156, 50);
    }

    public void draw(BrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        IDrawable drawable = this.guiHelper.createDrawableItemStack(recipe.getBeerCup());
        drawable.draw(stack, 73, 40);
    }

    public List<Component> getTooltipStrings(BrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (!this.inTransferBottomRange(mouseX, mouseY)) {
            if (this.inCupSlotRange(mouseX, mouseY)) {
                tooltips.add((Component)Component.m_237115_((String)"drinkbeer.jei.tooltip.cup_slot").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)DRINK_BEER_YELLOW))));
                tooltips.add((Component)Component.m_237115_((String)"drinkbeer.jei.tooltip.cup_1").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)NIGHT_HOWL_CUP_HEX_COLOR))).m_7220_((Component)Component.m_237113_((String)(recipe.getRequiredCupCount() + " ")).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131268_((String)DRINK_BEER_YELLOW)))).m_7220_((Component)Component.m_237115_((String)recipe.getBeerCup().m_41720_().m_5524_()).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237115_((String)"drinkbeer.jei.tooltip.cup_2").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)NIGHT_HOWL_CUP_HEX_COLOR)))));
            } else {
                int brewingTimeMin = recipe.getBrewingTime() / 20 / 60;
                int brewingTimeSec = recipe.getBrewingTime() / 20 - brewingTimeMin * 60;
                tooltips.add((Component)Component.m_237115_((String)"drinkbeer.jei.tooltip.brewing").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)PUMPKIN_DRINK_CUP_HEX_COLOR))).m_7220_((Component)Component.m_237113_((String)(brewingTimeMin + ":" + (Serializable)(brewingTimeSec < 10 ? "0" + brewingTimeSec : Integer.valueOf(brewingTimeSec)))).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131268_((String)DRINK_BEER_YELLOW)))));
            }
        }
        return tooltips;
    }

    public boolean handleInput(BrewingRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        return super.handleInput((Object)recipe, mouseX, mouseY, input);
    }

    private boolean inCupSlotRange(double mouseX, double mouseY) {
        return mouseX >= 72.0 && mouseX < 90.0 && mouseY >= 39.0 && mouseY <= 57.0;
    }

    private boolean inTransferBottomRange(double mouseX, double mouseY) {
        return mouseX >= 156.0 && mouseX < 169.0 && mouseY >= 50.0 && mouseY < 63.0;
    }
}

