/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blockentities;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.items.BeerMugItem;
import lekavar.lma.drinkbeer.items.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.items.SpiceBlockItem;
import lekavar.lma.drinkbeer.managers.MixedBeerManager;
import lekavar.lma.drinkbeer.registries.BlockEntityRegistry;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BartendingTableBlockEntity
extends BlockEntity {
    private final SimpleContainer inv = new OneItemContainer(2);
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> new BartendingTableInvWrapper(this));

    public BartendingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BARTENDING_TABLE_TILEENTITY.get(), pos, state);
    }

    public boolean placeBeer(ItemStack itemStack) {
        if (!this.inv.m_7983_()) {
            return false;
        }
        Item beerItem = itemStack.m_41720_();
        if (!(beerItem instanceof MixedBeerBlockItem) && !(beerItem instanceof BeerMugItem)) {
            return false;
        }
        List<Integer> spiceList = MixedBeerManager.getSpiceList(itemStack);
        if (spiceList.size() >= 3) {
            return false;
        }
        this.inv.m_6836_(0, itemStack);
        this.markDirty();
        return true;
    }

    public boolean putSpice(ItemStack itemStack) {
        List<Integer> spiceList;
        if (!(itemStack.m_41720_() instanceof SpiceBlockItem)) {
            return false;
        }
        if (this.inv.m_7983_()) {
            return false;
        }
        if (!this.inv.m_8020_(1).m_41619_() && (spiceList = MixedBeerManager.getSpiceList(this.inv.m_8020_(1))).size() >= 3) {
            return false;
        }
        ItemStack beerItem = this.inv.m_8020_(0);
        if (beerItem.m_41619_()) {
            beerItem = this.inv.m_8020_(1);
        }
        int beerId = beerItem.m_41720_() instanceof MixedBeerBlockItem ? MixedBeerBlockItem.getBeerId(beerItem) : Beers.byItem(beerItem.m_41720_()).getId();
        List<Integer> spiceList2 = MixedBeerManager.getSpiceList(beerItem);
        spiceList2.add(Spices.byItem(itemStack.m_41720_()).getId());
        ItemStack flavoredBeer = MixedBeerManager.genMixedBeerItemStack(beerId, spiceList2);
        this.inv.m_6836_(0, ItemStack.f_41583_);
        this.inv.m_6836_(1, flavoredBeer);
        this.markDirty();
        return true;
    }

    public ItemStack takeBeer(boolean simulate) {
        ItemStack ret = this.inv.m_8020_(0).m_41777_();
        if (ret.m_41619_()) {
            ret = this.inv.m_8020_(1).m_41777_();
        }
        if (!simulate && !ret.m_41619_()) {
            this.inv.m_6211_();
            this.markDirty();
        }
        return ret;
    }

    public void markDirty() {
        BlockPos pos = this.m_58899_();
        BlockState bs = this.f_58857_.m_8055_(pos);
        this.f_58857_.m_7260_(pos, bs, bs, 2);
        this.m_6596_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("input", (Tag)this.inv.m_8020_(0).serializeNBT());
        tag.m_128365_("output", (Tag)this.inv.m_8020_(1).serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.inv.m_6836_(0, ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("input"))));
        this.inv.m_6836_(1, ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("output"))));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("input", (Tag)this.inv.m_8020_(0).serializeNBT());
        tag.m_128365_("output", (Tag)this.inv.m_8020_(1).serializeNBT());
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.inv.m_6836_(0, ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("input"))));
        this.inv.m_6836_(1, ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("output"))));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    static class OneItemContainer
    extends SimpleContainer {
        public OneItemContainer(int pSize) {
            super(pSize);
        }

        public int m_6893_() {
            return 1;
        }
    }

    static class BartendingTableInvWrapper
    extends InvWrapper {
        Container inv;
        BartendingTableBlockEntity be;

        public BartendingTableInvWrapper(BartendingTableBlockEntity be) {
            super((Container)be.inv);
            this.inv = be.inv;
            this.be = be;
        }

        public int getSlots() {
            return 3;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 2) {
                return ItemStack.f_41583_;
            }
            return super.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0 && stack.m_41720_() instanceof MixedBeerBlockItem || stack.m_41720_() instanceof BeerMugItem) {
                if (!this.inv.m_7983_()) {
                    return stack;
                }
                List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
                if (spiceList.size() >= 3) {
                    return stack;
                }
                ItemStack ret = stack.m_41777_();
                if (!simulate) {
                    this.be.placeBeer(stack);
                }
                ret.m_41774_(1);
                return ret;
            }
            if (slot == 2 && stack.m_41720_() instanceof SpiceBlockItem) {
                List<Integer> spiceList;
                if (this.inv.m_7983_()) {
                    return stack;
                }
                if (!this.inv.m_8020_(1).m_41619_() && (spiceList = MixedBeerManager.getSpiceList(this.inv.m_8020_(1))).size() >= 3) {
                    return stack;
                }
                ItemStack ret = stack.m_41777_();
                if (!simulate) {
                    this.be.putSpice(stack);
                }
                ret.m_41774_(1);
                return ret;
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 || slot == 2) {
                return ItemStack.f_41583_;
            }
            if (!this.inv.m_8020_(1).m_41619_()) {
                return this.be.takeBeer(simulate);
            }
            return ItemStack.f_41583_;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 2) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0 && stack.m_41720_() instanceof MixedBeerBlockItem || stack.m_41720_() instanceof BeerMugItem) {
                if (!this.inv.m_7983_()) {
                    return false;
                }
                List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
                return spiceList.size() < 3;
            }
            if (slot == 2 && stack.m_41720_() instanceof SpiceBlockItem) {
                List<Integer> spiceList;
                if (this.inv.m_7983_()) {
                    return false;
                }
                return this.inv.m_8020_(1).m_41619_() || (spiceList = MixedBeerManager.getSpiceList(this.inv.m_8020_(1))).size() < 3;
            }
            return false;
        }
    }
}

