/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.events;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategory;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategoryManager;
import xyz.apex.forge.fantasyfurniture.AllItemGroupCategories;
import xyz.apex.forge.fantasyfurniture.AllParticleTypes;
import xyz.apex.forge.fantasyfurniture.core.ModInitializer;
import xyz.apex.forge.fantasyfurniture.core.ModRegistry;
import xyz.apex.forge.fantasyfurniture.core.data.ParticleProvider;
import xyz.apex.forge.fantasyfurniture.core.net.C2SSyncSelectedResultPacket;

@Mod.EventBusSubscriber(modid="fantasyfurniture", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonModEvents {
    private static final String OPTIFINE_ID = "optifine";

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        ModInitializer.NETWORK.registerPacket(C2SSyncSelectedResultPacket.class);
        ItemGroupCategoryManager.getInstance((CreativeModeTab)((CreativeModeTab)ModRegistry.CREATIVE_MODE_TAB.get())).addCategories(new ItemGroupCategory[]{AllItemGroupCategories.NORDIC, AllItemGroupCategories.DUNMER, AllItemGroupCategories.VENTHYR, AllItemGroupCategories.BONE, AllItemGroupCategories.ROYAL, AllItemGroupCategories.NECROLORD, AllItemGroupCategories.DECORATIONS});
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        boolean includeClient = event.includeClient();
        generator.m_236039_(includeClient, (DataProvider)new ParticleProvider(generator, event.getExistingFileHelper()){

            @Override
            public void registerParticleDefs() {
                this.definition((ParticleType)AllParticleTypes.SMALL_SOUL_FLAME.get()).texture((ParticleType<?>)ParticleTypes.f_123745_);
                this.definition((ParticleType)AllParticleTypes.NECROLORD_FLAME.get()).texture((ParticleType)AllParticleTypes.NECROLORD_FLAME.get());
                this.definition((ParticleType)AllParticleTypes.SMALL_NECROLORD_FLAME.get()).texture((ParticleType)AllParticleTypes.NECROLORD_FLAME.get());
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterPackFinders(AddPackFindersEvent event) {
        CommonModEvents.registerBuiltInPack(event, "ctm");
        CommonModEvents.registerBuiltInPack(event, "xycraft_core");
    }

    private static void registerBuiltInPack(AddPackFindersEvent event, String modId) {
        boolean modLoaded;
        boolean bl = modLoaded = modId.equals(OPTIFINE_ID) ? CommonModEvents.isOptifineInstalled() : ModList.get().isLoaded(modId);
        if (modLoaded) {
            try {
                IModFile modFile = ModList.get().getModFileById("fantasyfurniture").getFile();
                Path resourcePath = modFile.findResource(new String[]{"mod_support", modId});
                PathPackResources pack = new PathPackResources("%s:%s".formatted(modFile.getFileName(), resourcePath), resourcePath);
                PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                if (metadataSection != null) {
                    event.addRepositorySource((consumer, constructor) -> consumer.accept(constructor.create("builtin/mod_support/%s".formatted(modId), (Component)Component.m_237113_((String)"Fantasy's Furniture Mod-Support-Pack"), false, () -> pack, metadataSection, Pack.Position.TOP, PackSource.f_10528_, false)));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Fatal Error occurred while initializing mod-support builtin-resource-pack: '%s'".formatted(modId), e);
            }
        }
    }

    private static boolean isOptifineInstalled() {
        if (ModList.get().isLoaded(OPTIFINE_ID)) {
            return true;
        }
        try {
            Class.forName("net.optifine.ConnectedTextures");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

