/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.apex.forge.apexcore.lib.util.RegistryHelper;

public abstract class ParticleProvider
implements DataProvider {
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
    protected final DataGenerator generator;
    protected final ExistingFileHelper fileHelper;
    private final Map<ResourceLocation, ParticleDefinition> particleDefinitions = Maps.newHashMap();

    public ParticleProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        this.generator = generator;
        this.fileHelper = fileHelper;
    }

    public abstract void registerParticleDefs();

    public final void m_213708_(CachedOutput cache) throws IOException {
        this.particleDefinitions.clear();
        this.registerParticleDefs();
        this.validateParticleDefs();
        Path dataPath = this.generator.m_123916_().resolve("assets");
        this.particleDefinitions.forEach((particleName, def) -> ParticleProvider.saveParticleDefinition(cache, particleName, def, dataPath));
    }

    public String m_6055_() {
        return "Particles";
    }

    private void validateParticleDefs() {
        this.particleDefinitions.forEach((particleName, definition) -> {
            for (ResourceLocation texture : definition.textures) {
                ResourceLocation relativePath = new ResourceLocation(texture.m_135827_(), "particle/%s".formatted(texture.m_135815_()));
                Preconditions.checkArgument((boolean)this.fileHelper.exists(relativePath, (ExistingFileHelper.IResourceType)TEXTURE), (String)"Texture %s does not exist in any known resource pack", (Object)relativePath);
            }
        });
    }

    public static void saveParticleDefinition(CachedOutput cache, ResourceLocation particleName, ParticleDefinition definition, Path dataPath) {
        try {
            Path particlePath = dataPath.resolve(Paths.get(particleName.m_135827_(), "particles", "%s.json".formatted(particleName.m_135815_())));
            JsonElement serialized = ParticleProvider.serializeParticleDefinition(definition);
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)serialized, (Path)particlePath);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save ParticleDefinition {}", (Object)particleName);
        }
    }

    private static JsonElement serializeParticleDefinition(ParticleDefinition definition) {
        JsonObject json = new JsonObject();
        JsonArray texturesJson = new JsonArray();
        definition.textures.stream().map(Object::toString).forEach(arg_0 -> ((JsonArray)texturesJson).add(arg_0));
        json.add("textures", (JsonElement)texturesJson);
        return json;
    }

    public ParticleDefinition definition(ParticleType<?> particleType) {
        ResourceLocation name = RegistryHelper.getRegistryName((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, particleType);
        return this.particleDefinitions.computeIfAbsent(name, $ -> new ParticleDefinition());
    }

    public final class ParticleDefinition {
        private final Set<ResourceLocation> textures = Sets.newHashSet();

        private ParticleDefinition() {
        }

        public ParticleDefinition texture(ParticleType<?> particleType) {
            ResourceLocation name = RegistryHelper.getRegistryName((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, particleType);
            return this.texture(name);
        }

        public ParticleDefinition texture(ResourceLocation texture) {
            this.textures.add(texture);
            return this;
        }

        public ParticleDefinition textures(ResourceLocation ... textures) {
            Collections.addAll(this.textures, textures);
            return this;
        }

        public ParticleDefinition texture(String namespace, String texturePath) {
            return this.texture(new ResourceLocation(namespace, texturePath));
        }
    }
}

