/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.decorations;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.common.block.decorations.StackedBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;

public class ChalicesBlock
extends StackedBlock {
    public static final VoxelShape VENTHYR_SHAPE_0 = ChalicesBlock.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)8.0, (double)9.5);
    public static final VoxelShape VENTHYR_SHAPE_1 = VoxelShaper.or((VoxelShape[])new VoxelShape[]{ChalicesBlock.m_49796_((double)9.5, (double)0.0, (double)5.5, (double)12.5, (double)8.0, (double)8.5), ChalicesBlock.m_49796_((double)2.0, (double)0.0, (double)8.0, (double)6.0, (double)8.0, (double)12.0)});
    public static final VoxelShape VENTHYR_SHAPE_2 = VoxelShaper.or((VoxelShape[])new VoxelShape[]{ChalicesBlock.m_49796_((double)10.5, (double)0.0, (double)6.5, (double)13.5, (double)8.0, (double)9.5), ChalicesBlock.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)6.0, (double)8.0, (double)13.0), ChalicesBlock.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)9.0, (double)8.0, (double)6.0)});
    public static final VoxelShape BONE_SHAPE_0 = VoxelShaper.or((VoxelShape[])new VoxelShape[]{ChalicesBlock.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)1.0, (double)9.5), ChalicesBlock.m_49796_((double)7.25, (double)1.0, (double)7.25, (double)8.75, (double)4.0, (double)8.75), ChalicesBlock.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)});
    public static final VoxelShape BONE_SHAPE_1 = VoxelShaper.or((VoxelShape[])new VoxelShape[]{ChalicesBlock.m_49796_((double)3.5, (double)0.0, (double)8.5, (double)6.5, (double)1.0, (double)11.5), ChalicesBlock.m_49796_((double)4.25, (double)1.0, (double)9.25, (double)5.75, (double)4.0, (double)10.75), ChalicesBlock.m_49796_((double)3.0, (double)4.0, (double)8.0, (double)7.0, (double)8.0, (double)12.0), ChalicesBlock.m_49796_((double)8.25, (double)4.0, (double)4.25, (double)13.75, (double)8.0, (double)9.75), ChalicesBlock.m_49796_((double)9.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)9.0), ChalicesBlock.m_49796_((double)10.0, (double)1.0, (double)6.0, (double)12.0, (double)4.0, (double)8.0)});
    public static final VoxelShape BONE_SHAPE_2 = VoxelShaper.or((VoxelShape[])new VoxelShape[]{ChalicesBlock.m_49796_((double)4.5, (double)0.0, (double)10.5, (double)7.5, (double)1.0, (double)13.5), ChalicesBlock.m_49796_((double)5.25, (double)1.0, (double)11.25, (double)6.75, (double)4.0, (double)12.75), ChalicesBlock.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)8.0, (double)8.0, (double)14.0), ChalicesBlock.m_49796_((double)9.25, (double)4.0, (double)5.25, (double)14.75, (double)8.0, (double)10.75), ChalicesBlock.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)14.0, (double)1.0, (double)10.0), ChalicesBlock.m_49796_((double)11.0, (double)1.0, (double)7.0, (double)13.0, (double)4.0, (double)9.0), ChalicesBlock.m_49796_((double)1.25, (double)4.0, (double)2.25, (double)6.75, (double)8.0, (double)7.75), ChalicesBlock.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)6.0, (double)1.0, (double)7.0), ChalicesBlock.m_49796_((double)3.0, (double)1.0, (double)4.0, (double)5.0, (double)4.0, (double)6.0)});
    public static final VoxelShape ROYAL_SHAPE_0 = ChalicesBlock.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)8.0, (double)9.5);
    public static final VoxelShape ROYAL_SHAPE_1 = VoxelShaper.or((VoxelShape[])new VoxelShape[]{ChalicesBlock.m_49796_((double)9.5, (double)0.0, (double)5.5, (double)12.5, (double)8.0, (double)8.5), ChalicesBlock.m_49796_((double)2.5, (double)0.0, (double)8.5, (double)5.5, (double)8.0, (double)11.5)});
    public static final VoxelShape ROYAL_SHAPE_2 = VoxelShaper.or((VoxelShape[])new VoxelShape[]{ChalicesBlock.m_49796_((double)10.5, (double)0.0, (double)6.5, (double)13.5, (double)8.0, (double)9.5), ChalicesBlock.m_49796_((double)2.5, (double)0.0, (double)9.5, (double)5.5, (double)8.0, (double)12.5), ChalicesBlock.m_49796_((double)5.5, (double)0.0, (double)2.5, (double)8.5, (double)8.0, (double)5.5)});
    public static final IntegerProperty CHALICES = IntegerProperty.m_61631_((String)"chalices", (int)0, (int)2);
    public static final VoxelShaper VENTHYR_SHAPER_0 = VoxelShaper.forHorizontal((VoxelShape)VENTHYR_SHAPE_0, (Direction)Direction.NORTH);
    public static final VoxelShaper VENTHYR_SHAPER_1 = VoxelShaper.forHorizontal((VoxelShape)VENTHYR_SHAPE_1, (Direction)Direction.NORTH);
    public static final VoxelShaper VENTHYR_SHAPER_2 = VoxelShaper.forHorizontal((VoxelShape)VENTHYR_SHAPE_2, (Direction)Direction.NORTH);
    public static final VoxelShaper BONE_SHAPER_0 = VoxelShaper.forHorizontal((VoxelShape)BONE_SHAPE_0, (Direction)Direction.NORTH);
    public static final VoxelShaper BONE_SHAPER_1 = VoxelShaper.forHorizontal((VoxelShape)BONE_SHAPE_1, (Direction)Direction.NORTH);
    public static final VoxelShaper BONE_SHAPER_2 = VoxelShaper.forHorizontal((VoxelShape)BONE_SHAPE_2, (Direction)Direction.NORTH);
    public static final VoxelShaper ROYAL_SHAPER_0 = VoxelShaper.forHorizontal((VoxelShape)ROYAL_SHAPE_0, (Direction)Direction.NORTH);
    public static final VoxelShaper ROYAL_SHAPER_1 = VoxelShaper.forHorizontal((VoxelShape)ROYAL_SHAPE_1, (Direction)Direction.NORTH);
    public static final VoxelShaper ROYAL_SHAPER_2 = VoxelShaper.forHorizontal((VoxelShape)ROYAL_SHAPE_2, (Direction)Direction.NORTH);

    public ChalicesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public IntegerProperty getStackSizeProperty() {
        return CHALICES;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Direction facing = ChalicesBlock.getFacing((BlockState)blockState);
        Integer count = (Integer)blockState.m_61143_((Property)CHALICES);
        if (AllBlocks.VENTHYR_CHALICES.isIn(blockState)) {
            return (count == 2 ? VENTHYR_SHAPER_2 : (count == 1 ? VENTHYR_SHAPER_1 : VENTHYR_SHAPER_0)).get(facing);
        }
        if (AllBlocks.BONE_SKELETON_CHALICES.isIn(blockState) || AllBlocks.BONE_WITHER_CHALICES.isIn(blockState)) {
            return (count == 2 ? BONE_SHAPER_2 : (count == 1 ? BONE_SHAPER_1 : BONE_SHAPER_0)).get(facing);
        }
        if (AllBlocks.ROYAL_CHALICES.isIn(blockState)) {
            return (count == 2 ? ROYAL_SHAPER_2 : (count == 1 ? ROYAL_SHAPER_1 : ROYAL_SHAPER_0)).get(facing);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public static class Dyeable
    extends ChalicesBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MaterialColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
            MaterialColor mapColor = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, mapColor);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Override
        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        @Override
        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        @Override
        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }

        @Override
        protected ItemStack getPoppedStack(Level level, BlockPos pos, BlockState blockState, int count, Player player, InteractionHand hand) {
            ItemStack stack = super.getPoppedStack(level, pos, blockState, count, player, hand);
            return IDyeable.getCloneItemStack(blockState, (BlockGetter)level, pos, stack);
        }
    }
}

