/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.BasketBlock;
import vectorwing.farmersdelight.common.block.entity.Basket;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BasketBlockEntity
extends RandomizableContainerBlockEntity
implements Basket {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private int transferCooldown = -1;

    public BasketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BASKET.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compound)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        }
        this.transferCooldown = compound.m_128451_("TransferCooldown");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        }
        compound.m_128405_("TransferCooldown", this.transferCooldown);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public ItemStack m_7407_(int index, int count) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)count);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.m_59640_(null);
        this.m_7086_().set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    protected Component m_6820_() {
        return TextUtils.getTranslation("container.basket", new Object[0]);
    }

    public static boolean pullItems(Level level, Basket basket, int facingIndex) {
        for (ItemEntity itementity : BasketBlockEntity.getCaptureItems(level, basket, facingIndex)) {
            if (!BasketBlockEntity.captureItem(basket, itementity)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack putStackInInventoryAllSlots(Container destination, ItemStack stack) {
        int i = destination.m_6643_();
        for (int j = 0; j < i && !stack.m_41619_(); ++j) {
            stack = BasketBlockEntity.insertStack(destination, stack, j);
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(Container inventoryIn, ItemStack stack, int index, @Nullable Direction side) {
        if (!inventoryIn.m_7013_(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).m_7155_(index, stack, side);
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        if (stack1.m_41613_() > stack1.m_41741_()) {
            return false;
        }
        return ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    private static ItemStack insertStack(Container destination, ItemStack stack, int index) {
        ItemStack itemstack = destination.m_8020_(index);
        if (BasketBlockEntity.canInsertItemInSlot(destination, stack, index, null)) {
            boolean flag = false;
            boolean isDestinationEmpty = destination.m_7983_();
            if (itemstack.m_41619_()) {
                destination.m_6836_(index, stack);
                stack = ItemStack.f_41583_;
                flag = true;
            } else if (BasketBlockEntity.canCombine(itemstack, stack)) {
                int i = stack.m_41741_() - itemstack.m_41613_();
                int j = Math.min(stack.m_41613_(), i);
                stack.m_41774_(j);
                itemstack.m_41769_(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                BasketBlockEntity firstBasket;
                if (isDestinationEmpty && destination instanceof BasketBlockEntity && !(firstBasket = (BasketBlockEntity)destination).mayTransfer()) {
                    int k = 0;
                    firstBasket.setTransferCooldown(8 - k);
                }
                destination.m_6596_();
            }
        }
        return stack;
    }

    public static boolean captureItem(Container inventory, ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack entityItemStack = itemEntity.m_32055_().m_41777_();
        ItemStack remainderStack = BasketBlockEntity.putStackInInventoryAllSlots(inventory, entityItemStack);
        if (remainderStack.m_41619_()) {
            flag = true;
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(remainderStack);
        }
        return flag;
    }

    public static List<ItemEntity> getCaptureItems(Level level, Basket basket, int facingIndex) {
        return basket.getFacingCollectionArea(facingIndex).m_83299_().stream().flatMap(aabb -> level.m_6443_(ItemEntity.class, aabb.m_82386_(basket.getLevelX() - 0.5, basket.getLevelY() - 0.5, basket.getLevelZ() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return ChestMenu.m_39237_((int)id, (Inventory)player, (Container)this);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    private void updateHopper(Supplier<Boolean> supplier) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.isOnTransferCooldown() && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            boolean flag = false;
            if (!this.isFull()) {
                flag = supplier.get();
            }
            if (flag) {
                this.setTransferCooldown(8);
                this.m_6596_();
            }
        }
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            BlockPos blockpos = this.m_58899_();
            int facing = ((Direction)this.m_58900_().m_61143_((Property)BasketBlock.FACING)).m_122411_();
            if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-blockpos.m_123341_()), (double)(-blockpos.m_123342_()), (double)(-blockpos.m_123343_()))), (VoxelShape)this.getFacingCollectionArea(facing), (BooleanOp)BooleanOp.f_82689_)) {
                this.updateHopper(() -> BasketBlockEntity.captureItem(this, (ItemEntity)entity));
            }
        }
    }

    @Override
    public double getLevelX() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, BasketBlockEntity blockEntity) {
        --blockEntity.transferCooldown;
        if (!blockEntity.isOnTransferCooldown()) {
            blockEntity.setTransferCooldown(0);
            int facing = ((Direction)state.m_61143_((Property)BasketBlock.FACING)).m_122411_();
            blockEntity.updateHopper(() -> BasketBlockEntity.pullItems(level, blockEntity, facing));
        }
    }
}

