/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemdelete;

import java.util.List;
import net.doubledoordev.itemdelete.ItemdeleteConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="deleteitem")
public class DeleteItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public DeleteItem() {
        MinecraftForge.EVENT_BUS.register(ItemdeleteConfig.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ItemdeleteConfig.spec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "Forge making stupid decisions 101. Morons", (remote, isServer) -> true));
    }

    @SubscribeEvent
    public void clearContainer(PlayerContainerEvent event) {
        if (((Boolean)ItemdeleteConfig.GENERAL.isItOn.get()).booleanValue()) {
            AbstractContainerMenu container = event.getContainer();
            for (ItemStack itemStack : container.m_38927_()) {
                ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
                if (resourceLocation == null) {
                    return;
                }
                String itemName = resourceLocation.toString();
                if (!((List)ItemdeleteConfig.GENERAL.itemsToDelete.get()).contains(itemName)) continue;
                Player playerEntity = event.getEntity();
                HitResult hitResult = playerEntity.m_19907_(playerEntity.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get()), 0.0f, false);
                BlockPos blockPos = new BlockPos(hitResult.m_82450_());
                ResourceLocation resourceLocationMenu = null;
                try {
                    resourceLocationMenu = ForgeRegistries.MENU_TYPES.getKey((Object)container.m_6772_());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                String containerName = resourceLocationMenu == null ? "Unknown Container/Player Inventory" : resourceLocationMenu.toString();
                LOGGER.info("Delete Item has removed " + itemName + "(x" + itemStack.m_41613_() + ") from the game! Inside container: \"" + containerName + "\" at " + blockPos);
                itemStack.m_41764_(0);
            }
        }
    }

    @SubscribeEvent
    public void entitySpawnEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (((Boolean)ItemdeleteConfig.GENERAL.isItOn.get()).booleanValue() && !itemEntity.m_32055_().m_41619_()) {
            ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemEntity.m_32055_().m_41720_());
            if (resourceLocation == null) {
                return;
            }
            String itemName = resourceLocation.toString();
            if (((List)ItemdeleteConfig.GENERAL.itemsToDelete.get()).contains(itemName)) {
                String playerName = "Unknown Origin: Block break?";
                Player player = null;
                if (itemEntity.m_32057_() != null) {
                    player = event.getLevel().m_46003_(itemEntity.m_32057_());
                }
                if (player != null) {
                    playerName = player.m_5446_().getString();
                }
                LOGGER.info("Delete Item has removed ItemStack: " + itemName + "(x " + itemEntity.m_32055_().m_41613_() + ") from the game! Thrown by: \"" + playerName + "\" at " + itemEntity.m_20097_());
                event.setCanceled(true);
            }
        }
    }
}

