/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.epictweaks.forge.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    private final ForgeConfigSpec.ConfigValue<Boolean> filterAnimationFirstPerson;
    private final ForgeConfigSpec.ConfigValue<Boolean> enforceMode;
    private final ForgeConfigSpec spec;

    public ClientConfig() {
        this(new ForgeConfigSpec.Builder());
    }

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        this.filterAnimationFirstPerson = builder.comment(new String[]{"\nThis value only has an effect if Epic Fights 'filter_animation' is disabled.", "Set this to 'true' to prevent Epic Fights rendering in first person view while in mining mode.", "\nDefault: true"}).define("filter_animation_first_person", true);
        this.enforceMode = builder.comment(new String[]{"\nIf enabled the player cannot manually switch between battle or mining mode if the item in his hand is designated to either of the modes", "(i.e. the item was added to Epic Fights 'battle_autoswitch_items' or 'mining_autoswitch_items').", "\nDefault: true"}).define("enforce_mode", true);
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean getFilterAnimationFirstPerson() {
        return (Boolean)this.filterAnimationFirstPerson.get();
    }

    public boolean getEnforceMode() {
        return (Boolean)this.enforceMode.get();
    }
}

