/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.pack;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.crystalnest.cobweb.Constants;
import it.crystalnest.cobweb.api.pack.DynamicResourceType;
import it.crystalnest.cobweb.platform.Services;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements PackResources {
    private final PackType type;
    private final ResourceLocation name;
    private final String namespace;
    private final Set<String> namespaces = new HashSet<String>();
    private final Supplier<PackMetadataSection> metadata;
    private final Map<ResourceLocation, Supplier<byte[]>> resources = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();

    protected DynamicResourcePack(ResourceLocation name, PackType type) {
        this.type = type;
        this.name = name;
        this.namespace = name.m_135827_();
        this.namespaces.add(this.namespace);
        this.metadata = Suppliers.memoize(() -> new PackMetadataSection((Component)Component.m_237115_((String)(this.namespace + "_dynamic_" + name.m_135815_())), SharedConstants.m_183709_().getPackVersion(type.f_143750_)));
    }

    public void register() {
        Services.REGISTRY.registerDynamicResourcePack(this.type, (Supplier<Pack>)Suppliers.memoize(() -> {
            this.build();
            return new Pack(this.m_8017_(), (Component)Component.m_237115_((String)this.m_8017_()), true, () -> this, this.metadata.get(), this.type, Pack.Position.TOP, PackSource.f_10528_);
        }));
    }

    public String toString() {
        return this.m_8017_();
    }

    @Nullable
    public InputStream m_5542_(@NotNull String fileName) {
        return null;
    }

    @NotNull
    public InputStream m_8031_(@NotNull PackType type, @NotNull ResourceLocation id) {
        if (this.type == type && this.resources.containsKey(id)) {
            return new ByteArrayInputStream(this.resources.get(id).get());
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @NotNull
    public Collection<ResourceLocation> m_214146_(@NotNull PackType type, @NotNull String namespace, @NotNull String id, @NotNull Predicate<ResourceLocation> allowedPathPredicate) {
        if (this.type == type && this.namespaces.contains(namespace)) {
            return this.resources.keySet().stream().filter(resource -> resource.m_135827_().equals(namespace) && resource.m_135815_().startsWith(id) && allowedPathPredicate.test((ResourceLocation)resource)).toList();
        }
        return Collections.emptyList();
    }

    public boolean m_7211_(@NotNull PackType type, @NotNull ResourceLocation id) {
        return this.type == type && this.resources.containsKey(id);
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType packType) {
        return this.namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return (T)(serializer.m_7991_().equals(PackMetadataSection.f_10366_.m_7991_()) ? this.metadata : null);
    }

    @NotNull
    public String m_8017_() {
        return this.name.toString();
    }

    public void close() {
    }

    private void build(ResourceLocation path, Supplier<byte[]> bytes) {
        this.namespaces.add(path.m_135827_());
        this.resources.put(path, (Supplier<byte[]>)Suppliers.memoize(bytes::get));
    }

    protected void build(List<ResourceLocation> paths, Supplier<JsonElement> json) {
        for (ResourceLocation path : paths) {
            JsonElement element = json.get();
            this.build(DynamicResourceType.GENERAL.getPath(path), () -> {
                try (StringWriter stringWriter = new StringWriter();){
                    byte[] byArray;
                    try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                        jsonWriter.setIndent("  ");
                        Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
                        jsonWriter.close();
                        byArray = stringWriter.toString().getBytes();
                    }
                    return byArray;
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Failed to write JSON {} to resource pack\n{}.", new Object[]{path, this.name, e});
                    return new byte[0];
                }
            });
        }
    }

    protected abstract void build();
}

