/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import mcjty.incontrol.InControl;
import mcjty.incontrol.commands.ModCommands;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.data.Statistics;
import mcjty.incontrol.rules.ExperienceRule;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.RulesManager;
import mcjty.incontrol.rules.SpawnRule;
import mcjty.incontrol.rules.SpecialRule;
import mcjty.incontrol.rules.SummonAidRule;
import mcjty.incontrol.spawner.SpawnerSystem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    public static boolean debug = false;

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        int i = 0;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            return;
        }
        if (event.getLevel().f_46443_) {
            return;
        }
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getLevel())) {
            if (rule.isOnJoin() && rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Join Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getEntity().m_20183_().m_123342_());
                }
                if (result != Event.Result.DENY) {
                    Statistics.addSpawnStat(i, false);
                    rule.action(event);
                } else {
                    Statistics.addSpawnStat(i, true);
                    event.setCanceled(true);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldLast(EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_() && event.getEntity() instanceof LivingEntity && !(event.getEntity() instanceof Player)) {
            InControl.setup.cache.registerSpawn((LevelAccessor)event.getLevel(), event.getEntity().m_6095_());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.level.f_46443_) {
            InControl.setup.cache.performCount((LevelAccessor)event.level);
            if (!event.level.m_6907_().isEmpty()) {
                SpawnerSystem.checkRules(event);
            }
            if (event.level.m_46472_().equals((Object)Level.f_46428_)) {
                DataStorage.getData(event.level).tick(event.level);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpecialSpawnEvent(LivingSpawnEvent.SpecialSpawn event) {
        int i = 0;
        ServerLevel world = (ServerLevel)event.getEntity().m_20193_();
        for (SpecialRule rule : RulesManager.getFilteredSpecialRules((Level)world)) {
            if (rule.match(event)) {
                SpecialRule.SpecialResult result = rule.getResult();
                if (debug) {
                    Biome biome = (Biome)event.getLevel().m_204166_(new BlockPos(event.getX(), event.getY(), event.getZ())).m_203334_();
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Special " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getY() + " biome: " + ForgeRegistries.BIOMES.getKey((Object)biome));
                }
                switch (result) {
                    case BEFORE: {
                        event.setCanceled(false);
                        break;
                    }
                    case AFTER: {
                        event.getEntity().m_6518_((ServerLevelAccessor)world, world.m_6436_(event.getEntity().m_20183_()), MobSpawnType.NATURAL, null, null);
                        event.setCanceled(true);
                        break;
                    }
                    case REPLACE: {
                        event.setCanceled(true);
                    }
                }
                rule.action(event);
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        int i = 0;
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getEntity().m_20193_())) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Biome biome = (Biome)event.getLevel().m_204166_(new BlockPos(event.getX(), event.getY(), event.getZ())).m_203334_();
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getY() + " biome: " + ForgeRegistries.BIOMES.getKey((Object)biome));
                }
                if (result != null) {
                    event.setResult(result);
                }
                if (result != Event.Result.DENY) {
                    Statistics.addSpawnStat(i, false);
                    rule.action(event);
                } else {
                    Statistics.addSpawnStat(i, true);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSummonAidEvent(ZombieEvent.SummonAidEvent event) {
        int i = 0;
        for (SummonAidRule rule : RulesManager.getFilteredSummonAidRules(event.getLevel())) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    Biome biome = (Biome)event.getLevel().m_204166_(new BlockPos(event.getX(), event.getY(), event.getZ())).m_203334_();
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "SummonAid " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getY() + " biome: " + ForgeRegistries.BIOMES.getKey((Object)biome));
                }
                event.setResult(result);
                if (result != Event.Result.DENY) {
                    rule.action(event);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        int i = 0;
        for (ExperienceRule rule : RulesManager.getFilteredExperienceRuiles(event.getEntity().f_19853_)) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Experience Rule " + i + ": " + result + " entity: " + event.getEntity().m_7755_() + " y: " + event.getEntity().m_20183_().m_123342_());
                }
                if (result != Event.Result.DENY) {
                    int newxp = rule.modifyXp(event.getDroppedExperience());
                    event.setDroppedExperience(newxp);
                } else {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        Level world = event.getEntity().m_20193_();
        int i = 0;
        for (LootRule rule : RulesManager.getFilteredLootRules(world)) {
            if (rule.match(event)) {
                if (debug) {
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Loot " + i + ":  entity: " + event.getEntity().m_7755_());
                }
                if (rule.isRemoveAll()) {
                    event.getDrops().clear();
                } else {
                    ArrayList<ItemEntity> toRemove = null;
                    for (Predicate<ItemStack> predicate : rule.getToRemoveItems()) {
                        Collection drops = event.getDrops();
                        for (ItemEntity drop : drops) {
                            ItemStack stack = drop.m_32055_();
                            if (!predicate.test(stack)) continue;
                            if (toRemove == null) {
                                toRemove = new ArrayList<ItemEntity>();
                            }
                            toRemove.add(drop);
                        }
                    }
                    if (toRemove != null) {
                        Collection drops = event.getDrops();
                        for (ItemEntity entity : toRemove) {
                            drops.remove(entity);
                        }
                    }
                }
                for (Pair<ItemStack, Function<Integer, Integer>> pair : rule.getToAddItems()) {
                    ItemStack copy;
                    int amount;
                    ItemStack itemStack = (ItemStack)pair.getLeft();
                    int fortune = event.getLootingLevel();
                    BlockPos pos = event.getEntity().m_20183_();
                    for (amount = ((Integer)((Function)pair.getValue()).apply(fortune)).intValue(); amount > itemStack.m_41741_(); amount -= itemStack.m_41741_()) {
                        copy = itemStack.m_41777_();
                        copy.m_41764_(itemStack.m_41741_());
                        event.getDrops().add(new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), copy));
                    }
                    if (amount <= 0) continue;
                    copy = itemStack.m_41777_();
                    copy.m_41764_(amount);
                    event.getDrops().add(new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), copy));
                }
            }
            ++i;
        }
    }
}

