/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.EnchantCalcConf;
import io.github.flemmli97.improvedmobs.config.EquipmentList;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class Utils {
    public static final Function<Entity, ResourceLocation> entityID = e -> PlatformUtils.INSTANCE.entities().getIDFrom((Object)e.m_6095_());
    public static final Function<Item, ResourceLocation> itemID = e -> PlatformUtils.INSTANCE.items().getIDFrom(e);
    public static final UUID attMod = UUID.fromString("7c7e5c2d-1eb0-434a-858f-3ab81f52832c");

    public static <T> boolean isInList(T entry, List<? extends String> list, boolean reverse, Function<T, ResourceLocation> mapper) {
        if (reverse) {
            return !Utils.isInList(entry, list, false, mapper);
        }
        ResourceLocation res = mapper.apply(entry);
        return list.contains(res.m_135815_()) || list.contains(res.toString());
    }

    public static boolean canHarvest(BlockState block, ItemStack item) {
        return item.m_41735_(block) || !block.m_60834_();
    }

    public static void equipArmor(Mob living, float difficulty) {
        if (Config.CommonConfig.baseEquipChance != 0.0f) {
            float time = difficulty * Config.CommonConfig.diffEquipAdd * 0.01f;
            if (living.m_217043_().m_188501_() < Config.CommonConfig.baseEquipChance + time) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack equip;
                    boolean shouldAdd;
                    if (slot.m_20743_() == EquipmentSlot.Type.HAND) continue;
                    boolean bl = shouldAdd = slot == EquipmentSlot.HEAD || Config.CommonConfig.baseEquipChanceAdd != 0.0f && living.m_217043_().m_188501_() < Config.CommonConfig.baseEquipChanceAdd + time;
                    if (!shouldAdd || !living.m_6844_(slot).m_41619_() || (equip = EquipmentList.getEquip(living, slot, difficulty)).m_41619_()) continue;
                    if (!Config.CommonConfig.shouldDropEquip) {
                        living.m_21409_(slot, -100.0f);
                    }
                    living.m_8061_(slot, equip);
                }
            }
        }
    }

    public static void equipHeld(Mob living, float difficulty) {
        ItemStack stack;
        float add = difficulty * Config.CommonConfig.diffWeaponChance * 0.01f;
        if (Config.CommonConfig.baseWeaponChance != 0.0f && living.m_217043_().m_188501_() < Config.CommonConfig.baseWeaponChance + add && living.m_21205_().m_41619_()) {
            stack = EquipmentList.getEquip(living, EquipmentSlot.MAINHAND, difficulty);
            if (!Config.CommonConfig.shouldDropEquip) {
                living.m_21409_(EquipmentSlot.MAINHAND, -100.0f);
            }
            living.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
        if (living instanceof AbstractPiglin) {
            return;
        }
        add = difficulty * Config.CommonConfig.diffItemChanceAdd * 0.01f;
        if (Config.CommonConfig.baseItemChance != 0.0f && living.m_217043_().m_188501_() < Config.CommonConfig.baseItemChance + add && living.m_21206_().m_41619_()) {
            stack = EquipmentList.getEquip(living, EquipmentSlot.OFFHAND, difficulty);
            if (!Config.CommonConfig.shouldDropEquip) {
                living.m_21409_(EquipmentSlot.OFFHAND, -100.0f);
            }
            living.m_8061_(EquipmentSlot.OFFHAND, stack);
        }
    }

    public static void enchantGear(Mob living, float difficulty) {
        EnchantCalcConf.Value val = Config.CommonConfig.enchantCalc.get(difficulty);
        if (val.max == 0) {
            return;
        }
        for (EquipmentSlot entityequipmentslot : EquipmentSlot.values()) {
            ItemStack itemstack = living.m_6844_(entityequipmentslot);
            if (itemstack.m_41793_() || itemstack.m_41619_() || !(living.m_217043_().m_188501_() < Config.CommonConfig.baseEnchantChance + difficulty * Config.CommonConfig.diffEnchantAdd * 0.01f)) continue;
            EnchantmentHelper.m_220292_((RandomSource)living.m_217043_(), (ItemStack)itemstack, (int)Mth.m_216271_((RandomSource)living.m_217043_(), (int)val.min, (int)val.max), (boolean)true);
        }
    }

    public static float getBlockStrength(Mob entityLiving, BlockState state, Level world, BlockPos pos) {
        float hardness = world.m_8055_(pos).m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        ItemStack main = entityLiving.m_21205_();
        ItemStack off = entityLiving.m_21206_();
        if (Utils.canHarvest(state, main)) {
            float offSpeed;
            float speed = Utils.getBreakSpeed(entityLiving, main, state);
            if (Utils.canHarvest(state, off) && (offSpeed = Utils.getBreakSpeed(entityLiving, off, state)) > speed) {
                speed = offSpeed;
            }
            return speed / hardness / 30.0f;
        }
        if (Utils.canHarvest(state, off)) {
            return Utils.getBreakSpeed(entityLiving, off, state) / hardness / 30.0f;
        }
        return Utils.getBreakSpeed(entityLiving, main, state) / hardness / 100.0f;
    }

    public static float getBreakSpeed(Mob entity, ItemStack stack, BlockState state) {
        float f = stack.m_41691_(state);
        if (f > 1.0f) {
            int i = EnchantmentHelper.m_44926_((LivingEntity)entity);
            ItemStack itemstack = entity.m_21205_();
            if (i > 0 && !itemstack.m_41619_()) {
                f += (float)(i * i + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.m_21023_(MobEffects.f_19599_)) {
            switch (entity.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0: {
                    f *= 0.3f;
                    break;
                }
                case 1: {
                    f *= 0.09f;
                    break;
                }
                case 2: {
                    f *= 0.0027f;
                    break;
                }
                default: {
                    f *= 8.1E-4f;
                }
            }
        }
        if (entity.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)entity)) {
            f /= 5.0f;
        }
        if (!entity.m_20096_()) {
            f /= 5.0f;
        }
        return f;
    }

    public static void modifyAttr(Mob living, Attribute att, double value, double max, float difficulty, boolean multiply) {
        AttributeInstance inst = living.m_21051_(att);
        if (inst == null || inst.m_22111_(attMod) != null) {
            return;
        }
        double oldValue = inst.m_22115_();
        value *= (double)difficulty;
        if (multiply) {
            value = max <= 0.0 ? value : Math.min(value, max - 1.0);
            value = oldValue * value;
            if (att == Attributes.f_22276_) {
                value = Config.CommonConfig.roundHP > 0.0 ? MathUtils.roundTo((double)value, (double)Config.CommonConfig.roundHP) : value;
            }
        } else {
            value = max <= 0.0 ? value : Math.min(value, max);
        }
        inst.m_22125_(new AttributeModifier(attMod, "im_modifier", value, AttributeModifier.Operation.ADDITION));
    }
}

