/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.forge.capability;

import io.github.flemmli97.improvedmobs.difficulty.IPlayerDifficulty;
import io.github.flemmli97.improvedmobs.forge.capability.TileCapProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDifficultyData
implements IPlayerDifficulty,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<IPlayerDifficulty> holder = LazyOptional.of(() -> this);
    private float difficultyLevel;

    @Override
    public void setDifficultyLevel(float level) {
        this.difficultyLevel = level;
    }

    @Override
    public float getDifficultyLevel() {
        return this.difficultyLevel;
    }

    @Override
    public void load(CompoundTag nbt) {
        this.difficultyLevel = nbt.m_128457_("IMDifficulty");
    }

    @Override
    public CompoundTag save(CompoundTag compound) {
        compound.m_128350_("IMDifficulty", this.difficultyLevel);
        return compound;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return TileCapProvider.PLAYER_CAP.orEmpty(capability, this.holder);
    }

    public CompoundTag serializeNBT() {
        return this.save(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag arg) {
        this.load(arg);
    }
}

