/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.tenshilib.api.config.IConfigListValue;
import io.github.flemmli97.tenshilib.common.utils.ArrayUtils;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;

public class EntityModifyFlagConfig
implements IConfigListValue<EntityModifyFlagConfig> {
    private final Map<String, EnumSet<Flags>> map = new HashMap<String, EnumSet<Flags>>();

    public void initDefault(Level world) {
        this.map.clear();
        for (EntityType entry : PlatformUtils.INSTANCE.entities().getIterator()) {
            try {
                Entity e = entry.m_20615_(world);
                if (!(e instanceof Mob)) continue;
                EnumSet<Flags> set = EnumSet.noneOf(Flags.class);
                for (Flags flag : Flags.values()) {
                    if (flag.tag == null || !entry.m_204041_().m_203656_(flag.tag)) continue;
                    set.add(flag);
                }
                if (set.isEmpty() && !(e instanceof Enemy)) {
                    set.add(Flags.ALL);
                }
                if (set.isEmpty()) continue;
                this.map.put(PlatformUtils.INSTANCE.entities().getIDFrom((Object)entry).toString(), set);
            }
            catch (Exception e) {
                ImprovedMobs.logger.error("Error during default entity config for EntityType {}, skipping this type. Cause: {}", (Object)PlatformUtils.INSTANCE.entities().getIDFrom((Object)entry), (Object)e.getMessage());
            }
        }
    }

    public boolean hasFlag(Mob living, Flags flag, boolean reverse) {
        ResourceLocation res = PlatformUtils.INSTANCE.entities().getIDFrom((Object)living.m_6095_());
        if (res == null) {
            return true;
        }
        if (Config.CommonConfig.flagBlacklist.contains(flag.toString())) {
            return true;
        }
        EnumSet<Flags> set = this.map.get(res.toString());
        if (set == null) {
            set = this.map.get(res.m_135827_());
        }
        if (set != null) {
            return reverse ^ set.contains((Object)Flags.REVERSE) ^ (set.contains((Object)Flags.ALL) || set.contains((Object)flag));
        }
        return reverse;
    }

    public EntityModifyFlagConfig readFromString(List<String> s) {
        this.map.clear();
        for (String val : s) {
            EnumSet<Flags> set;
            String[] subs = val.split("\\|");
            if (subs.length == 1) {
                set = EnumSet.of(Flags.ALL);
            } else {
                set = EnumSet.noneOf(Flags.class);
                for (int i = 1; i < subs.length; ++i) {
                    set.add(Flags.valueOf(subs[i].trim()));
                }
            }
            this.map.put(subs[0].trim(), set);
        }
        return this;
    }

    public List<String> writeToString() {
        ArrayList<String> s = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            StringBuilder val = new StringBuilder(key);
            for (Flags f : this.map.get(key)) {
                if (f == Flags.ALL) continue;
                val.append("|").append(f.name());
            }
            s.add(val.toString());
        }
        return s;
    }

    public static String use() {
        CharSequence[] str = new String[]{"Entities added here will be blacklisted from their assigned flags. Usage:", "<entity registry name> or <namespace> followed by any of:", "[" + ArrayUtils.arrayToString((Object[])Flags.values()) + "].", "Having no flags is equal to ALL. Use REVERSE to reverse all flags. Some flags do nothing for certain mobs!", "Examples (without <>):", "<minecraft:sheep> (equal to minecraft:sheep|ALL) excludes sheeps from all modifications", "<minecraft:sheep|REVERSE|ATTRIBUTES will> add sheep to attributes modification only", "<minecraft:sheep|ATTRIBUTES> will add sheep to everything except attributes", "<minecraft> blacklists all minecraft mobs from everything"};
        return String.join((CharSequence)"\n", str);
    }

    public static enum Flags {
        ALL(null),
        ATTRIBUTES("attributes"),
        ARMOR("armor"),
        HELDITEMS("helditems"),
        BLOCKBREAK("blockbreak"),
        USEITEM("useitem"),
        LADDER("ladder"),
        STEAL("steal"),
        GUARDIAN("guardian"),
        PARROT("parrot"),
        TARGETVILLAGER("villager"),
        NEUTRALAGGRO("neutral"),
        REVERSE(null);

        public final TagKey<EntityType<?>> tag;

        private Flags(String id) {
            this.tag = id == null ? null : TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("improvedmobs", "default_blacklist_" + id));
        }

        public static List<Flags> toggable() {
            ArrayList<Flags> all = new ArrayList<Flags>(Arrays.asList(Flags.values()));
            all.remove((Object)ALL);
            all.remove((Object)REVERSE);
            return all;
        }
    }
}

