/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import io.github.flemmli97.tenshilib.api.config.IConfigListValue;
import io.github.flemmli97.tenshilib.common.utils.SearchUtils;
import java.util.ArrayList;
import java.util.List;

public class EnchantCalcConf
implements IConfigListValue<EnchantCalcConf> {
    private static final Value defaultVal = new Value(0, 0, 0);
    private final List<Value> vals = new ArrayList<Value>();

    public EnchantCalcConf readFromString(List<String> ss) {
        this.vals.clear();
        ArrayList<Value> list = new ArrayList<Value>();
        for (String s : ss) {
            String[] parts = s.split("-");
            if (parts.length != 3) continue;
            list.add(new Value(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
        }
        list.sort(null);
        this.vals.addAll(list);
        return this;
    }

    public List<String> writeToString() {
        ArrayList<String> list = new ArrayList<String>();
        this.vals.forEach(v -> list.add(v.diff + "-" + v.min + "-" + v.max));
        return list;
    }

    public Value get(float difficulty) {
        return (Value)SearchUtils.searchInfFunc(this.vals, v -> Float.compare(v.diff, difficulty), (Comparable)defaultVal);
    }

    public static class Value
    implements Comparable<Value> {
        public final int min;
        public final int max;
        public final float diff;

        Value(int diff, int min, int max) {
            this.min = min;
            this.max = max;
            this.diff = diff;
        }

        @Override
        public int compareTo(Value o) {
            return Float.compare(this.diff, o.diff);
        }
    }
}

