/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.registrar;

import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import com.cstav.genshinstrument.sound.registrar.impl.AbstractNoteSoundRegistrar;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HeldNoteSoundRegistrar
extends AbstractNoteSoundRegistrar<HeldNoteSound, HeldNoteSoundRegistrar> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HashMap<ResourceLocation, HeldNoteSound[]> SOUNDS_REGISTRY = new HashMap();
    protected NoteSound[] attack;
    protected NoteSound[] hold;
    @Nullable
    protected NoteSound[] release = null;
    protected float holdDelay = 0.0f;
    protected float chainedHoldDelay = 0.0f;
    protected float decay = -1.0f;
    protected float releaseFadeOut = 0.0f;
    protected float fullHoldFadeoutTime = 0.0f;

    public static HeldNoteSound[] getSounds(ResourceLocation baseSoundName) {
        return SOUNDS_REGISTRY.get(baseSoundName);
    }

    public HeldNoteSoundRegistrar(DeferredRegister<SoundEvent> sounds, ResourceLocation baseSoundLocation) {
        super(sounds, baseSoundLocation);
    }

    @Override
    public HeldNoteSoundRegistrar getThis() {
        return this;
    }

    public HeldNoteSoundRegistrar holdDelay(float holdDelay) {
        this.holdDelay = holdDelay;
        return this.getThis();
    }

    public HeldNoteSoundRegistrar chainedHoldDelay(float chainedHoldDelay) {
        this.chainedHoldDelay = chainedHoldDelay;
        return this.getThis();
    }

    public HeldNoteSoundRegistrar decays(float iterations) {
        this.decay = 1.0f / iterations;
        return this.getThis();
    }

    public HeldNoteSoundRegistrar releaseFadeOut(float releaseFadeOut) {
        this.releaseFadeOut = releaseFadeOut;
        return this.getThis();
    }

    public HeldNoteSoundRegistrar fullHoldFadeoutTime(float fullHoldFadeoutTime) {
        this.fullHoldFadeoutTime = fullHoldFadeoutTime;
        return this.getThis();
    }

    public HeldNoteSoundRegistrar buildSoundsForAll(Function<NoteSoundRegistrar, NoteSound[]> builder) {
        return this.getThis().attackBuilder(builder).holdBuilder(builder).releaseBuilder(builder);
    }

    public HeldNoteSoundRegistrar attackBuilder(Function<NoteSoundRegistrar, NoteSound[]> builder) {
        this.attack = this.applyBuilder(builder, "_attack");
        return this.getThis();
    }

    public HeldNoteSoundRegistrar holdBuilder(Function<NoteSoundRegistrar, NoteSound[]> builder) {
        this.hold = this.applyBuilder(builder, "_hold");
        return this.getThis();
    }

    public HeldNoteSoundRegistrar releaseBuilder(Function<NoteSoundRegistrar, NoteSound[]> builder) {
        this.release = this.applyBuilder(builder, "_release");
        return this.getThis();
    }

    protected NoteSound[] applyBuilder(Function<NoteSoundRegistrar, NoteSound[]> builder, String pathSuffix) {
        return builder.apply(this.nsr(CommonUtil.withSuffix(this.baseSoundLocation, pathSuffix)));
    }

    private NoteSoundRegistrar nsr(ResourceLocation instrumentId) {
        return new NoteSoundRegistrar((DeferredRegister<SoundEvent>)this.soundRegistrar, instrumentId);
    }

    public HeldNoteSound[] register(float holdDuration) {
        assert (!this.validateLengths()) : "Invalid lengths of sounds provided to HeldNoteSoundRegistrar!\nAll sounds must be of equal lengths.";
        HeldNoteSound[] noteSounds = new HeldNoteSound[this.sounds()];
        for (int i = 0; i < this.sounds(); ++i) {
            noteSounds[i] = new HeldNoteSound(this.baseSoundLocation, i, this.attack[i], this.hold[i], this.release == null ? null : this.release[i], holdDuration, this.holdDelay, this.chainedHoldDelay, this.decay, this.releaseFadeOut, this.fullHoldFadeoutTime);
        }
        SOUNDS_REGISTRY.put(this.baseSoundLocation, noteSounds);
        LOGGER.info("Successfully loaded {} (x2, {} total) held note sounds for {}", new Object[]{noteSounds.length, noteSounds.length * 2, this.baseSoundLocation});
        return noteSounds;
    }

    protected boolean validateLengths() {
        return this.attack.length == this.hold.length && this.sounds() != 0;
    }

    public int sounds() {
        return this.attack.length;
    }
}

