/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import com.cstav.genshinstrument.util.CommonUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HeldNoteSoundInstance
extends AbstractTickableSoundInstance {
    public final HeldNoteSound heldSoundContainer;
    public final HeldNoteSound.Phase phase;
    public final ResourceLocation instrumentId;
    public final Optional<Entity> initiator;
    public final InitiatorID initiatorId;
    public final Optional<BlockPos> soundOrigin;
    public final int notePitch;
    private boolean released;
    protected int timeAlive = 0;
    protected int overallTimeAlive;
    protected boolean chainedHolding = false;

    protected HeldNoteSoundInstance(HeldNoteSound heldSoundContainer, HeldNoteSound.Phase phase, int notePitch, float volume, @Nullable Entity initiator, @Nullable BlockPos soundOrigin, InitiatorID initiatorId, ResourceLocation instrumentId, int timeAlive, boolean released) {
        super(heldSoundContainer.getSound(phase).getByPreference(HeldNoteSoundInstance.distFromSourceSqr(soundOrigin, initiator)), NoteSound.INSTRUMENT_SOUND_SOURCE, SoundInstance.m_235150_());
        this.initiatorId = initiatorId;
        this.instrumentId = instrumentId;
        this.heldSoundContainer = heldSoundContainer;
        this.phase = phase;
        this.overallTimeAlive = timeAlive;
        this.initiator = Optional.ofNullable(initiator);
        this.soundOrigin = Optional.ofNullable(soundOrigin);
        this.f_119573_ = volume;
        this.notePitch = notePitch;
        this.f_119574_ = NoteSound.getPitchByNoteOffset(notePitch);
        this.released = released;
        if (this.distFromSourceSqr() < Mth.m_144952_((double)5.5)) {
            this.f_119580_ = SoundInstance.Attenuation.NONE;
            this.f_119582_ = true;
            this.f_119577_ = 0.0;
            this.f_119576_ = 0.0;
            this.f_119575_ = 0.0;
        } else {
            this.f_119580_ = SoundInstance.Attenuation.LINEAR;
            this.f_119582_ = false;
            this.soundOrigin.ifPresentOrElse(loc -> {
                this.f_119575_ = loc.m_123341_();
                this.f_119576_ = loc.m_123342_();
                this.f_119577_ = loc.m_123343_();
            }, this::toInitiatorPos);
        }
    }

    public HeldNoteSoundInstance(HeldNoteSound heldSoundContainer, HeldNoteSound.Phase phase, int notePitch, float volume, @Nullable Entity initiator, @Nullable BlockPos soundOrigin, InitiatorID initiatorId, ResourceLocation instrumentId) {
        this(heldSoundContainer, phase, notePitch, volume, initiator, soundOrigin, initiatorId, instrumentId, 0, false);
    }

    public void queueAndAddInstance() {
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)this);
        ClientUtil.stopMusicIfClose(this.soundOrigin.orElseGet(this.initiator.map(Entity::m_20183_)::get));
        this.addSoundInstance();
    }

    public void addSoundInstance() {
        HeldNoteSounds.put(this.initiatorId, this.heldSoundContainer, this.notePitch, this);
    }

    protected void removeSoundInstance() {
        HeldNoteSounds.release(this.initiatorId, this.heldSoundContainer, this.notePitch, this);
    }

    public void setReleased() {
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.phase == HeldNoteSound.Phase.HOLD && this.heldSoundContainer.release() != null) {
            Vec3 pos = this.getSourcePos();
            this.heldSoundContainer.release().playLocally(this.f_119574_, this.f_119573_, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    protected static double distFromSourceSqr(@Nullable BlockPos soundOrigin, @Nullable Entity initiator) {
        return Minecraft.m_91087_().f_91074_.m_20182_().m_82557_(HeldNoteSoundInstance.getSourcePos(soundOrigin, initiator));
    }

    public double distFromSourceSqr() {
        return Minecraft.m_91087_().f_91074_.m_20182_().m_82557_(this.getSourcePos());
    }

    protected static Vec3 getSourcePos(@Nullable BlockPos soundOrigin, @Nullable Entity initiator) {
        return soundOrigin == null ? initiator.m_20182_() : CommonUtil.getCenter(soundOrigin);
    }

    protected Vec3 getSourcePos() {
        return HeldNoteSoundInstance.getSourcePos(this.soundOrigin.orElse(null), this.initiator.orElse(null));
    }

    public void m_7788_() {
        this.toInitiatorPos();
        this.handleChainHolding();
        if (this.released) {
            float fadeOutMultiplier = 1.0f;
            float fhft = this.heldSoundContainer.fullHoldFadeoutTime() * 20.0f;
            if (this.phase == HeldNoteSound.Phase.HOLD && fhft != 0.0f && (float)this.overallTimeAlive < fhft) {
                fadeOutMultiplier = 1.0f / ((float)(this.overallTimeAlive + 1) / fhft);
            }
            this.f_119573_ -= this.heldSoundContainer.releaseFadeOut() * fadeOutMultiplier;
            if (this.f_119573_ <= 0.0f) {
                this.stopHeld();
            }
        }
        ++this.timeAlive;
        ++this.overallTimeAlive;
    }

    protected void handleChainHolding() {
        if (this.chainedHolding || this.f_119574_ == 0.0f) {
            return;
        }
        switch (this.phase) {
            case ATTACK: {
                if (this.timeAlive != (int)(this.heldSoundContainer.holdDelay() * 20.0f)) break;
                this.queueHoldPhase(false);
                this.chainedHolding = true;
                break;
            }
            case HOLD: {
                if (!((float)this.timeAlive * this.f_119574_ >= (float)((int)((this.heldSoundContainer.holdDuration() + this.heldSoundContainer.chainedHoldDelay()) * 20.0f)))) break;
                this.queueHoldPhase(this.heldSoundContainer.decay() > 0.0f);
                this.chainedHolding = true;
                this.removeSoundInstance();
            }
        }
    }

    protected void queueHoldPhase(boolean decreaseVol) {
        if (this.f_119573_ <= 0.2f) {
            return;
        }
        new HeldNoteSoundInstance(this.heldSoundContainer, HeldNoteSound.Phase.HOLD, this.notePitch, this.f_119573_ - (decreaseVol ? this.heldSoundContainer.decay() : 0.0f), this.initiator.orElse(null), this.soundOrigin.orElse(null), this.initiatorId, this.instrumentId, this.overallTimeAlive, this.released).queueAndAddInstance();
    }

    protected void toInitiatorPos() {
        if (this.f_119582_) {
            return;
        }
        if (this.soundOrigin.isPresent() || this.initiator.isEmpty()) {
            return;
        }
        if (this.released) {
            return;
        }
        this.f_119575_ = this.initiator.get().m_20185_();
        this.f_119576_ = this.initiator.get().m_20186_();
        this.f_119577_ = this.initiator.get().m_20189_();
    }

    public float m_7769_() {
        return this.f_119573_;
    }

    public float m_7783_() {
        return this.f_119574_;
    }

    public void stopHeld() {
        this.m_119609_();
        this.removeSoundInstance();
    }
}

