/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.util;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.event.InstrumentOpenStateChangedEvent;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.OpenInstrumentPacketSender;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.OpenInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CNotePacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.S2CNotePacketDelegate;
import com.cstav.genshinstrument.util.CommonUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class InstrumentPacketUtil {
    public static final int PLAY_DISTANCE = 24;

    public static <T, P extends S2CNotePacket<T>> P sendPlayerPlayNotePackets(Entity initiator, T sound, NoteSoundMetadata soundMeta, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        P packet = notePacketDelegate.create(Optional.of(initiator.m_19879_()), sound, soundMeta);
        for (Player listener : InstrumentPacketUtil.noteListeners(initiator.m_9236_(), soundMeta.pos())) {
            GIPacketHandler.sendToClient(packet, (ServerPlayer)listener);
        }
        initiator.m_9236_().m_220407_(GameEvent.f_223696_, soundMeta.pos(), GameEvent.Context.m_223717_((Entity)initiator));
        return packet;
    }

    public static <T, P extends S2CNotePacket<T>> P sendPlayerPlayNotePackets(Entity initiator, T sound, ResourceLocation instrumentId, int pitch, int volume, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        return InstrumentPacketUtil.sendPlayerPlayNotePackets(initiator, sound, new NoteSoundMetadata(initiator.m_20183_(), pitch, volume, instrumentId, Optional.empty()), notePacketDelegate);
    }

    public static <T, P extends S2CNotePacket<T>> P sendPlayNotePackets(Level level, T sound, NoteSoundMetadata soundMeta, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        P packet = notePacketDelegate.create(Optional.empty(), sound, soundMeta);
        for (Player listener : InstrumentPacketUtil.noteListeners(level, soundMeta.pos())) {
            GIPacketHandler.sendToClient(packet, (ServerPlayer)listener);
        }
        BlockState bs = level.m_8055_(soundMeta.pos());
        if (bs != Blocks.f_50016_.m_49966_()) {
            level.m_220407_(GameEvent.f_223696_, soundMeta.pos(), GameEvent.Context.m_223722_((BlockState)bs));
        } else {
            level.m_142346_(null, GameEvent.f_223696_, soundMeta.pos());
        }
        return packet;
    }

    public static <T, P extends S2CNotePacket<T>> P sendPlayNotePackets(Level level, BlockPos pos, T sound, ResourceLocation instrumentId, int pitch, int volume, S2CNotePacketDelegate<T, P> notePacketDelegate) {
        return InstrumentPacketUtil.sendPlayNotePackets(level, sound, new NoteSoundMetadata(pos, pitch, volume, instrumentId, Optional.empty()), notePacketDelegate);
    }

    public static List<Player> noteListeners(Level level, BlockPos pos) {
        return CommonUtil.getPlayersInArea(level, new AABB(pos).m_82400_(24.0));
    }

    public static void setInstrumentClosed(ServerPlayer player) {
        if (!InstrumentOpenProvider.isOpen((Player)player)) {
            return;
        }
        InstrumentOpenProvider.setClosed((Player)player);
        player.m_9236_().m_6907_().forEach(oPlayer -> GIPacketHandler.sendToClient(new NotifyInstrumentOpenPacket(player.m_20148_()), oPlayer));
        boolean isItem = InstrumentOpenProvider.isItem((Player)player);
        MinecraftForge.EVENT_BUS.post((Event)new InstrumentOpenStateChangedEvent(false, (Player)player, isItem ? Optional.empty() : Optional.of(InstrumentOpenProvider.getBlockPos((Player)player)), isItem ? Optional.of(InstrumentOpenProvider.getHand((Player)player)) : Optional.empty()));
    }

    public static boolean sendOpenPacket(ServerPlayer player, InteractionHand usedHand, OpenInstrumentPacketSender onOpenRequest) {
        return InstrumentPacketUtil.sendOpenPacket(player, usedHand, onOpenRequest, null);
    }

    public static boolean sendOpenPacket(ServerPlayer player, OpenInstrumentPacketSender onOpenRequest, BlockPos pos) {
        return InstrumentPacketUtil.sendOpenPacket(player, null, onOpenRequest, pos);
    }

    private static boolean sendOpenPacket(ServerPlayer player, InteractionHand usedHand, OpenInstrumentPacketSender onOpenRequest, BlockPos pos) {
        NotifyInstrumentOpenPacket instrumentOpenPacket;
        if (pos == null) {
            InstrumentOpenProvider.setOpen((Player)player, usedHand);
            instrumentOpenPacket = new NotifyInstrumentOpenPacket(player.m_20148_(), usedHand);
        } else {
            InstrumentOpenProvider.setOpen((Player)player, pos);
            instrumentOpenPacket = new NotifyInstrumentOpenPacket(player.m_20148_(), pos);
        }
        player.m_9236_().m_6907_().forEach(otherPlayer -> GIPacketHandler.sendToClient(instrumentOpenPacket, otherPlayer));
        MinecraftForge.EVENT_BUS.post((Event)new InstrumentOpenStateChangedEvent(true, (Player)player, pos == null ? Optional.empty() : Optional.of(pos), pos == null ? Optional.of(usedHand) : Optional.empty()));
        onOpenRequest.send(player);
        return true;
    }

    public static void sendOpenPacket(ServerPlayer player, ResourceLocation instrumentID) {
        GIPacketHandler.sendToClient(new OpenInstrumentPacket(instrumentID), player);
    }
}

