/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.c2s;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public abstract class C2SNotePacket<T>
implements IModPacket {
    public static final NetworkDirection NETWORK_DIRECTION = NetworkDirection.PLAY_TO_SERVER;
    public final T sound;
    public final NoteSoundMetadata meta;

    public C2SNotePacket(T sound, NoteSoundMetadata meta) {
        this.sound = sound;
        this.meta = meta;
    }

    @OnlyIn(value=Dist.CLIENT)
    public C2SNotePacket(NoteButton noteButton, T sound, int pitch) {
        this(sound, new NoteSoundMetadata(noteButton.getSoundSourcePos(), pitch, noteButton.instrumentScreen.volume, noteButton.instrumentScreen.getInstrumentId(), Optional.ofNullable(noteButton.getIdentifier())));
    }

    public C2SNotePacket(FriendlyByteBuf buf) {
        this.sound = this.readSound(buf);
        this.meta = NoteSoundMetadata.read(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        this.writeSound(buf);
        this.meta.write(buf);
    }

    protected abstract T readSound(FriendlyByteBuf var1);

    protected abstract void writeSound(FriendlyByteBuf var1);

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        this.sendPlayNotePackets(player);
    }

    protected abstract void sendPlayNotePackets(ServerPlayer var1);
}

