/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public abstract class InstrumentPlayedEvent<T>
extends Event {
    private final T sound;
    private final NoteSoundMetadata soundMeta;
    private final Level level;
    private final Optional<EntityInfo> entityInfo;

    public boolean isByEntity() {
        return this.entityInfo.isPresent();
    }

    public boolean isByPlayer() {
        return this.isByEntity() && this.entityInfo.get().entity instanceof Player;
    }

    public InstrumentPlayedEvent(Level level, T sound, NoteSoundMetadata soundMeta) {
        this.level = level;
        this.sound = sound;
        this.soundMeta = soundMeta;
        this.entityInfo = Optional.empty();
    }

    public InstrumentPlayedEvent(Entity entity, T sound, NoteSoundMetadata soundMeta) {
        this.level = entity.m_9236_();
        this.sound = sound;
        this.soundMeta = soundMeta;
        this.entityInfo = Optional.of(new EntityInfo(entity));
    }

    public T sound() {
        return this.sound;
    }

    public NoteSoundMetadata soundMeta() {
        return this.soundMeta;
    }

    public Level level() {
        return this.level;
    }

    public Optional<EntityInfo> entityInfo() {
        return this.entityInfo;
    }

    public float volume() {
        return (float)this.soundMeta.volume() / 100.0f;
    }

    public class EntityInfo {
        public final Entity entity;
        public final Optional<InteractionHand> hand;
        protected final InstrumentPlayedEvent<T> baseEvent;

        public EntityInfo(Entity entity) {
            Player player;
            this.baseEvent = InstrumentPlayedEvent.this;
            this.entity = entity;
            this.hand = entity instanceof Player && InstrumentOpenProvider.isItem(player = (Player)entity) ? Optional.of(InstrumentOpenProvider.getHand(player)) : Optional.empty();
        }

        public boolean isItemInstrument() {
            return this.hand.isPresent();
        }

        public boolean isBlockInstrument() {
            return !this.isItemInstrument() && InstrumentPlayedEvent.this.level.m_7702_(this.baseEvent.soundMeta.pos()) instanceof InstrumentBlockEntity;
        }

        public boolean isNotInstrument() {
            return !this.isBlockInstrument() && !this.isItemInstrument();
        }
    }
}

