/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.enumType.SoundType;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.SingleButtonOptionsScreen;
import com.cstav.genshinstrument.client.util.TogglablePedalSound;
import com.cstav.genshinstrument.event.MidiEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="genshinstrument", value={Dist.CLIENT})
public abstract class SoundTypeOptionsScreen<T extends SoundType>
extends SingleButtonOptionsScreen {
    private T preferredSoundType = this.getInitSoundType();
    private int heightBefore;

    public SoundTypeOptionsScreen(GridInstrumentScreen screen) {
        super(screen);
    }

    public SoundTypeOptionsScreen(Screen lastScreen) {
        super(lastScreen);
    }

    public T getPreferredSoundType() {
        return this.preferredSoundType;
    }

    public void setPreferredSoundType(T preferredSoundType) {
        this.preferredSoundType = preferredSoundType;
        if (this.instrumentScreen.map(this::isValidForSet).orElse(false).booleanValue()) {
            ((InstrumentScreen)((Object)this.instrumentScreen.get())).setNoteSounds(preferredSoundType.getSoundArr().get());
        }
    }

    protected abstract T getInitSoundType();

    protected abstract T[] values();

    protected abstract String soundTypeButtonKey();

    @Override
    protected abstract String optionsLabelKey();

    @Override
    protected AbstractButton constructButton() {
        return CycleButton.m_168894_(soundType -> Component.m_237115_((String)(this.soundTypeButtonKey() + "." + soundType.getName()))).m_168961_((Object[])this.values()).m_168948_(this.getPreferredSoundType()).m_168936_(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)this.soundTypeButtonKey()), this::onSoundTypeChange);
    }

    protected void onSoundTypeChange(CycleButton<T> btn, T soundType) {
        this.setPreferredSoundType(soundType);
        this.instrumentScreen.ifPresent(screen -> this.queueToSave(screen.getInstrumentId().m_135815_() + "_sound_type", () -> this.saveSoundType(soundType)));
    }

    protected abstract void saveSoundType(T var1);

    protected abstract boolean isValidForSet(InstrumentScreen var1);

    public TogglablePedalSound<T> midiPedalListener() {
        return null;
    }

    @SubscribeEvent
    public static void onMidiReceivedEvent(MidiEvent event) {
        InstrumentOptionsScreen instrumentOptionsScreen;
        InstrumentScreen instrumentScreen = InstrumentScreen.getCurrentScreen(Minecraft.m_91087_()).orElse(null);
        if (instrumentScreen == null || !((instrumentOptionsScreen = instrumentScreen.optionsScreen) instanceof SoundTypeOptionsScreen)) {
            return;
        }
        SoundTypeOptionsScreen optionsScreen = (SoundTypeOptionsScreen)instrumentOptionsScreen;
        TogglablePedalSound pedalSounds = optionsScreen.midiPedalListener();
        if (optionsScreen.midiPedalListener() == null) {
            return;
        }
        byte[] message = event.message.getMessage();
        if (message[0] != -80 && message[0] != -176 || message[1] != 64) {
            return;
        }
        optionsScreen.setPreferredSoundType(message[2] >= 64 ? pedalSounds.enabled : pedalSounds.disabled);
    }
}

