/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteRing;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.NoteAnimationController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NoteButtonRenderer {
    protected static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static final double SHARP_MULTIPLIER = 0.9;
    protected static final double NOTE_DUR = 0.15;
    protected static final double NOTE_TARGET_VAL = 9.0;
    public final NoteButton noteButton;
    protected final InstrumentScreen instrumentScreen;
    protected final ResourceLocation rootLocation;
    protected final ResourceLocation accidentalsLocation;
    protected final ResourceLocation notePressedLocation;
    protected final ResourceLocation noteReleasedLocation;
    protected final ResourceLocation noteHoverLocation;
    protected Supplier<ResourceLocation> noteTextureProvider;
    public final NoteAnimationController noteAnimation;
    public boolean foreignPlaying = false;
    protected final ArrayList<NoteRing> rings = new ArrayList();
    private int labelX;
    private int labelY;

    protected NoteAnimationController initNoteAnimation() {
        return new NoteAnimationController(0.15, 9.0, this.noteButton);
    }

    public NoteButtonRenderer(NoteButton noteButton, Supplier<ResourceLocation> noteTextureProvider) {
        this.noteButton = noteButton;
        this.noteTextureProvider = noteTextureProvider;
        this.instrumentScreen = noteButton.instrumentScreen;
        this.noteAnimation = this.initNoteAnimation();
        this.rootLocation = this.instrumentScreen.getResourceFromRoot("note");
        this.accidentalsLocation = this.getResourceFromRoot("accidentals.png");
        this.notePressedLocation = this.getResourceFromRoot("note/pressed.png");
        this.noteReleasedLocation = this.getResourceFromRoot("note/released.png");
        this.noteHoverLocation = this.getResourceFromRoot("note/hovered.png");
    }

    public void render(PoseStack stack, int mouseX, int mouseY, float partialTick, InstrumentThemeLoader themeLoader) {
        RenderSystem.m_69478_();
        this.rings.removeIf(ring -> !ring.isPlaying());
        this.rings.forEach(ring -> ring.render(stack, themeLoader));
        this.renderNoteButton(stack, themeLoader);
        this.renderNote(stack, themeLoader);
        this.renderLabel(stack, themeLoader);
        this.renderAccidentals(stack, themeLoader);
        this.noteAnimation.update();
    }

    protected void renderNoteButton(PoseStack stack, InstrumentThemeLoader themeLoader) {
        ResourceLocation noteLocation = this.noteButton.isPlaying() ? (this.foreignPlaying ? this.noteHoverLocation : this.notePressedLocation) : (this.noteButton.m_198029_() ? this.noteHoverLocation : this.noteReleasedLocation);
        ClientUtil.displaySprite(noteLocation);
        GuiComponent.m_93133_((PoseStack)stack, (int)this.noteButton.f_93620_, (int)this.noteButton.f_93621_, (float)0.0f, (float)0.0f, (int)this.noteButton.m_5711_(), (int)this.noteButton.m_93694_(), (int)this.noteButton.m_5711_(), (int)this.noteButton.m_93694_());
    }

    protected void renderNote(PoseStack stack, InstrumentThemeLoader themeLoader) {
        int noteWidth = this.noteButton.m_5711_() / 2;
        int noteHeight = this.noteButton.m_93694_() / 2;
        ClientUtil.setShaderColor(this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.notePressed() : themeLoader.noteReleased());
        ClientUtil.displaySprite(this.noteTextureProvider.get());
        GuiComponent.m_93133_((PoseStack)stack, (int)(this.noteButton.f_93620_ + noteWidth / 2), (int)(this.noteButton.f_93621_ + noteHeight / 2), (float)0.0f, (float)0.0f, (int)noteWidth, (int)noteHeight, (int)noteWidth, (int)(this.noteButton.m_93694_() / 2));
        ClientUtil.resetShaderColor();
    }

    public void setLabelX(int labelX) {
        this.labelX = labelX;
    }

    public void setLabelY(int labelY) {
        this.labelY = labelY;
    }

    protected void renderLabel(PoseStack stack, InstrumentThemeLoader themeLoader) {
        GuiComponent.m_93215_((PoseStack)stack, (Font)NoteButtonRenderer.MINECRAFT.f_91062_, (Component)this.noteButton.m_6035_(), (int)this.labelX, (int)this.labelY, (int)(this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.labelPressed() : themeLoader.labelReleased()).getRGB());
    }

    protected void renderAccidentals(PoseStack stack, InstrumentThemeLoader themeLoader) {
        RenderSystem.m_69478_();
        switch (this.noteButton.getNotation()) {
            case NONE: {
                break;
            }
            case FLAT: {
                this.renderAccidental(stack, 0);
                break;
            }
            case SHARP: {
                this.renderAccidental(stack, 1);
                break;
            }
            case DOUBLE_FLAT: {
                this.renderAccidental(stack, 0, -6, -3);
                this.renderAccidental(stack, 0, 5, 2);
                break;
            }
            case DOUBLE_SHARP: {
                this.renderAccidental(stack, 2, -1, 0);
            }
        }
    }

    protected void renderAccidental(PoseStack stack, int index) {
        this.renderAccidental(stack, index, 0, 0);
    }

    protected void renderAccidental(PoseStack stack, int index, int offsetX, int offsetY) {
        double textureMultiplier = (double)this.noteButton.m_5711_() * (index == 1 ? 0.9 : 1.0) * 2.0;
        int textureWidth = (int)textureMultiplier;
        int textureHeight = (int)textureMultiplier - 1;
        int spritePartWidth = textureWidth / 3 + 1;
        ClientUtil.displaySprite(this.accidentalsLocation);
        GuiComponent.m_93133_((PoseStack)stack, (int)(this.noteButton.f_93620_ - 9 + offsetX), (int)(this.noteButton.f_93621_ - 5 + offsetY), (float)(spritePartWidth * index), (float)(this.noteButton.isPlaying() ? (float)((textureHeight + 1) / 2) : 0.0f), (int)(spritePartWidth - 1), (int)(textureHeight / 2), (int)textureWidth, (int)textureHeight);
    }

    public void playNoteAnimation(boolean isForeign) {
        this.foreignPlaying = isForeign;
        this.noteAnimation.play(isForeign);
        this.addRing();
    }

    public void addRing() {
        NoteRing ring = new NoteRing(this.noteButton, this.foreignPlaying);
        this.rings.add(ring);
        ring.playAnim();
    }

    public void resetAnimations() {
        this.rings.clear();
        this.noteAnimation.stop();
    }

    protected ResourceLocation getResourceFromRoot(String path) {
        return CommonUtil.getResourceFrom(this.rootLocation, path);
    }
}

