/*
 * Decompiled with CFR 0.152.
 */
package com.sindarin.farsightedmobs;

import com.sindarin.farsightedmobs.FarsightedMobs;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    public static Map<EntityType<?>, Pair<Attribute, Double>> parseMobAttributes(List<? extends String> unparsed, Attribute attribute, double minValue, double maxValue) {
        HashMap map = new HashMap();
        for (String string : unparsed) {
            String[] split = string.split(",");
            if (split.length != 2) {
                FarsightedMobs.LOGGER.warn("Invalid line in server config: " + string);
                continue;
            }
            ResourceLocation entityName = ResourceLocation.m_135820_((String)split[0]);
            if (entityName == null) {
                FarsightedMobs.LOGGER.warn("Invalid resource location in server config: " + string);
                continue;
            }
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(entityName)) {
                FarsightedMobs.LOGGER.warn("Could not find entity: " + string);
                continue;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityName);
            if (!NumberUtils.isParsable((String)split[1])) {
                FarsightedMobs.LOGGER.warn("Invalid number for attribute: " + string);
                continue;
            }
            double value = Double.parseDouble(split[1]);
            if (value > maxValue) {
                FarsightedMobs.LOGGER.warn("Number is too big for attribute: " + string);
                continue;
            }
            if (value < minValue) {
                FarsightedMobs.LOGGER.warn("Number is too small for attribute: " + string);
                continue;
            }
            map.put(entityType, (Pair<Attribute, Double>)Pair.of((Object)attribute, (Object)value));
        }
        return map;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        if (!event.getConfig().getModId().equals("farsightedmobs")) {
            return;
        }
        SERVER.onLoadConfig();
    }

    static {
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.DoubleValue defaultHostileRange;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mobAttributeList;
        public Map<EntityType<?>, List<Pair<Attribute, Double>>> mobAttributeMap;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.defaultHostileRange = builder.comment(new String[]{"The minimum follow range for hostile mobs", "Only overridden if the original mob's follow range was lower", "Default value: 32. Vanilla behaviour: 16"}).defineInRange("minHostileFollowRange", 32.0, 0.0, 2048.0);
            this.mobAttributeList = builder.comment(new String[]{"A list of follow range overrides. Entry format: \"mod:entity_id,range\"", "Example: [\"minecraft:creeper,32\",\"minecraft:zombie,16\"]", "Default value: []"}).defineList("mobFollowRangeOverrides", Collections.emptyList(), o -> o instanceof String);
        }

        public void onLoadConfig() {
            this.mobAttributeMap = new HashMap();
            Map<EntityType<?>, Pair<Attribute, Double>> followRanges = Config.parseMobAttributes((List)this.mobAttributeList.get(), Attributes.f_22277_, 0.0, 2048.0);
            for (Map.Entry<EntityType<?>, Pair<Attribute, Double>> attribute : followRanges.entrySet()) {
                if (this.mobAttributeMap.containsKey(attribute.getKey())) {
                    this.mobAttributeMap.get(attribute.getKey()).add(attribute.getValue());
                    continue;
                }
                this.mobAttributeMap.put(attribute.getKey(), Collections.singletonList(attribute.getValue()));
            }
        }
    }
}

