/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.goal;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AnimatedAttackGoal<T extends MobPatch<?>>
extends Goal {
    protected final T mobpatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public AnimatedAttackGoal(T mobpatch, CombatBehaviors<T> combatBehaviors) {
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    public boolean m_8036_() {
        return this.checkTargetValid();
    }

    public void m_8037_() {
        if (((MobPatch)this.mobpatch).getTarget() != null) {
            CombatBehaviors.Behavior<T> result;
            EntityState state = ((LivingEntityPatch)this.mobpatch).getEntityState();
            this.combatBehaviors.tick();
            if (this.combatBehaviors.hasActivatedMove()) {
                CombatBehaviors.Behavior<T> result2;
                if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                    result2.execute(this.mobpatch);
                }
            } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
                result.execute(this.mobpatch);
            }
        }
    }

    private boolean checkTargetValid() {
        LivingEntity livingentity = ((MobPatch)this.mobpatch).getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }
}

