/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.skill;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class CapabilitySkill {
    public static final CapabilitySkill EMPTY = new CapabilitySkill(null);
    public final SkillContainer[] skillContainers;
    private final HashMultimap<SkillCategory, SkillContainer> slotByCategory = HashMultimap.create();
    private final HashMultimap<SkillCategory, Skill> learnedSkills = HashMultimap.create();

    public CapabilitySkill(PlayerPatch<?> playerpatch) {
        Collection<SkillSlot> slots = SkillSlot.ENUM_MANAGER.universalValues();
        this.skillContainers = new SkillContainer[slots.size()];
        for (SkillSlot slot : slots) {
            SkillContainer skillContainer;
            this.skillContainers[slot.universalOrdinal()] = skillContainer = new SkillContainer(playerpatch, slot);
            this.slotByCategory.put((Object)slot.category(), (Object)skillContainer);
        }
    }

    public void clear() {
        int i = 0;
        for (SkillContainer container : this.skillContainers) {
            if (SkillSlot.ENUM_MANAGER.get(i).category().learnable()) {
                container.setSkill(null);
            }
            ++i;
        }
        this.learnedSkills.clear();
    }

    public void addLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (!this.learnedSkills.containsKey((Object)category) || !this.learnedSkills.get((Object)category).contains(skill)) {
            this.learnedSkills.put((Object)category, (Object)skill);
        }
    }

    public boolean removeLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (this.learnedSkills.containsKey((Object)category) && this.learnedSkills.remove((Object)category, (Object)skill)) {
            if (this.learnedSkills.get((Object)category).size() == 0) {
                this.learnedSkills.removeAll((Object)category);
            }
            return true;
        }
        return false;
    }

    public Collection<Skill> getLearnedSkills(SkillCategory skillCategory) {
        return this.learnedSkills.get((Object)skillCategory);
    }

    public boolean hasCategory(SkillCategory skillCategory) {
        return this.learnedSkills.containsKey((Object)skillCategory);
    }

    public Set<SkillContainer> getSkillContainersFor(SkillCategory skillCategory) {
        return this.slotByCategory.get((Object)skillCategory);
    }

    public SkillContainer getSkillContainer(Skill skill) {
        Set containers = this.slotByCategory.get((Object)skill.getCategory());
        for (SkillContainer skillContainer : containers) {
            if (!skill.equals(skillContainer.getSkill())) continue;
            return skillContainer;
        }
        return null;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        for (SkillContainer container : this.skillContainers) {
            if (container.getSkill() == null || !container.getSkill().getCategory().shouldSave()) continue;
            nbt.m_128359_(container.getSlot().toString().toLowerCase(Locale.ROOT), container.getSkill().toString());
        }
        for (Map.Entry entry : this.learnedSkills.asMap().entrySet()) {
            CompoundTag learnedNBT = new CompoundTag();
            int i = 0;
            for (Skill skill : (Collection)entry.getValue()) {
                learnedNBT.m_128359_(String.valueOf(i++), skill.toString());
            }
            nbt.m_128365_("learned:" + ((SkillCategory)entry.getKey()).toString().toLowerCase(Locale.ROOT), (Tag)learnedNBT);
        }
        nbt.m_128359_("playerMode", this.skillContainers[0].getExecuter().getPlayerMode().toString());
        return nbt;
    }

    public void fromNBT(CompoundTag nbt) {
        Skill skill;
        for (SkillContainer container : this.skillContainers) {
            String key = container.getSlot().toString().toLowerCase(Locale.ROOT);
            if (!nbt.m_128441_(key) || (skill = SkillManager.getSkill(nbt.m_128461_(key))) == null) continue;
            container.setSkill(skill);
            this.addLearnedSkill(skill);
        }
        for (SkillCategory category : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!nbt.m_128441_("learned:" + category.toString().toLowerCase(Locale.ROOT))) continue;
            CompoundTag learnedNBT = nbt.m_128469_("learned:" + category.toString().toLowerCase(Locale.ROOT));
            for (String key : learnedNBT.m_128431_()) {
                skill = SkillManager.getSkill(learnedNBT.m_128461_(key));
                if (skill == null) continue;
                this.addLearnedSkill(skill);
            }
        }
        if (nbt.m_128441_("playerMode")) {
            this.skillContainers[0].getExecuter().toMode(PlayerPatch.PlayerMode.valueOf(nbt.m_128461_("playerMode").toUpperCase(Locale.ROOT)), true);
        } else {
            this.skillContainers[0].getExecuter().toMiningMode(true);
        }
    }
}

