/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPAddLearnedSkill;
import yesman.epicfight.network.server.SPAddOrRemoveSkillData;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.network.server.SPModifyPlayerData;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.DodgeSuccessEvent;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SetTargetEvent;

public class ServerPlayerPatch
extends PlayerPatch<ServerPlayer> {
    private LivingEntity attackTarget;
    private boolean updatedMotionCurrentTick;

    @Override
    public void onJoinWorld(ServerPlayer player, EntityJoinLevelEvent event) {
        super.onJoinWorld(player, event);
        CapabilitySkill skillCapability = this.getSkillCapability();
        for (SkillContainer skill2 : skillCapability.skillContainers) {
            if (skill2.getSkill() == null || !skill2.getSkill().getCategory().shouldSynchronize()) continue;
            EpicFightNetworkManager.sendToPlayer(new SPChangeSkill(skill2.getSlot(), skill2.getSkill().toString(), SPChangeSkill.State.ENABLE), (ServerPlayer)this.original);
        }
        ArrayList learnedSkill = Lists.newArrayList();
        for (SkillCategory category : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!skillCapability.hasCategory(category)) continue;
            learnedSkill.addAll(Lists.newArrayList(skillCapability.getLearnedSkills(category).stream().map(skill -> skill.toString()).iterator()));
        }
        EpicFightNetworkManager.sendToPlayer(new SPAddLearnedSkill(learnedSkill.toArray(new String[0])), (ServerPlayer)this.original);
        EpicFightNetworkManager.sendToPlayer(new SPModifyPlayerData(((ServerPlayer)this.getOriginal()).m_19879_(), this.playerMode), (ServerPlayer)this.original);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.getOriginal()).m_19879_());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        for (SkillContainer container : this.getSkillCapability().skillContainers) {
            for (SkillDataManager.SkillDataKey<?> key : container.getDataManager().keySet()) {
                if (!key.shouldSyncAllClients()) continue;
                EpicFightNetworkManager.sendToPlayer(new SPAddOrRemoveSkillData(key, container.getSlot().universalOrdinal(), container.getDataManager().getDataValue(key), SPAddOrRemoveSkillData.AddRemove.ADD, ((ServerPlayer)this.original).m_19879_()), trackingPlayer);
            }
        }
        EpicFightNetworkManager.sendToPlayer(msg, trackingPlayer);
        EpicFightNetworkManager.sendToPlayer(new SPModifyPlayerData(((ServerPlayer)this.getOriginal()).m_19879_(), this.playerMode), trackingPlayer);
    }

    @Override
    public void gatherDamageDealt(EpicFightDamageSource source, float amount) {
        if (source.isBasicAttack()) {
            float value;
            SkillContainer container = this.getSkill(SkillSlots.WEAPON_INNATE);
            ItemStack mainHandItem = ((ServerPlayer)this.getOriginal()).m_21205_();
            if (!container.isFull() && !container.isActivated() && container.hasSkill(EpicFightCapabilities.getItemStackCapability(mainHandItem).getInnateSkill(this, mainHandItem)) && (value = container.getResource() + amount) > 0.0f) {
                this.getSkill(SkillSlots.WEAPON_INNATE).getSkill().setConsumptionSynchronize(this, value);
            }
        }
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        this.updatedMotionCurrentTick = false;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        if (this.isChargingSkill()) {
            Skill skill = this.chargingSkill.asSkill();
            skill.cancelOnServer(this, null);
            this.resetSkillCharging();
            EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.expired(this.getSkill(skill).getSlotId()), (ServerPlayer)this.original);
        }
        CapabilityItem mainHandCap = hand == InteractionHand.MAIN_HAND ? toCap : this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        mainHandCap.changeWeaponInnateSkill(this, hand == InteractionHand.MAIN_HAND ? to : ((ServerPlayer)this.original).m_21205_());
        if (hand == InteractionHand.OFF_HAND) {
            Multimap<Attribute, AttributeModifier> modifiers;
            if (!from.m_41619_()) {
                modifiers = from.m_41638_(EquipmentSlot.MAINHAND);
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!fromCap.isEmpty()) {
                modifiers = fromCap.getAllAttributeModifiers(EquipmentSlot.MAINHAND);
                modifiers.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22130_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22130_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22130_(arg_0));
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!to.m_41619_()) {
                modifiers = to.m_41638_(EquipmentSlot.MAINHAND);
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
            if (!toCap.isEmpty()) {
                modifiers = toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this);
                modifiers.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22118_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22118_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22118_(arg_0));
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem();
        super.updateHeldItem(fromCap, toCap, from, to, hand);
    }

    public void modifyLivingMotionByCurrentItem() {
        if (this.updatedMotionCurrentTick) {
            return;
        }
        ((Animator)this.getAnimator()).resetLivingAnimations();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap motionModifier = Maps.newHashMap();
        offhandCap.getLivingMotionModifier(this, InteractionHand.OFF_HAND).forEach(motionModifier::put);
        mainhandCap.getLivingMotionModifier(this, InteractionHand.MAIN_HAND).forEach(motionModifier::put);
        for (Map.Entry entry : motionModifier.entrySet()) {
            ((Animator)this.getAnimator()).addLivingAnimation((LivingMotion)entry.getKey(), (StaticAnimation)entry.getValue());
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.original).m_19879_());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayer)this.original);
        this.updatedMotionCurrentTick = true;
    }

    @Override
    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch.AnimationPacketProvider packetProvider) {
        super.playAnimationSynchronized(animation, convertTimeModifier, packetProvider);
        EpicFightNetworkManager.sendToPlayer(packetProvider.get(animation, convertTimeModifier, this), (ServerPlayer)this.original);
    }

    @Override
    public void reserveAnimation(StaticAnimation animation) {
        super.reserveAnimation(animation);
        EpicFightNetworkManager.sendToPlayer(new SPPlayAnimation(animation, ((ServerPlayer)this.original).m_19879_(), 0.0f), (ServerPlayer)this.original);
    }

    @Override
    public void changeModelYRot(float amount) {
        super.changeModelYRot(amount);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPModifyPlayerData(((ServerPlayer)this.original).m_19879_(), this.modelYRot), (ServerPlayer)this.original);
    }

    @Override
    public boolean consumeStamina(float amount) {
        float currentStamina = this.getStamina();
        if (currentStamina < amount) {
            return false;
        }
        this.setStamina(currentStamina - amount);
        this.resetActionTick();
        return true;
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        HurtEvent.Pre hurtEvent = new HurtEvent.Pre(this, damageSource, amount);
        if (this.getEventListener().triggerEvents(PlayerEventListener.EventType.HURT_EVENT_PRE, hurtEvent)) {
            return new AttackResult(hurtEvent.getResult(), hurtEvent.getAmount());
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void onDodgeSuccess(DamageSource damageSource) {
        super.onDodgeSuccess(damageSource);
        DodgeSuccessEvent dodgeSuccessEvent = new DodgeSuccessEvent(this, damageSource);
        this.getEventListener().triggerEvents(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, dodgeSuccessEvent);
    }

    @Override
    public void toMiningMode(boolean synchronize) {
        super.toMiningMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPModifyPlayerData(((ServerPlayer)this.original).m_19879_(), PlayerPatch.PlayerMode.MINING), (ServerPlayer)this.original);
        }
    }

    @Override
    public void toBattleMode(boolean synchronize) {
        super.toBattleMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPModifyPlayerData(((ServerPlayer)this.original).m_19879_(), PlayerPatch.PlayerMode.BATTLE), (ServerPlayer)this.original);
        }
    }

    @Override
    public boolean isTeammate(Entity entityIn) {
        if (entityIn instanceof Player && !((ServerPlayer)this.getOriginal()).f_8924_.m_129799_()) {
            return true;
        }
        return super.isTeammate(entityIn);
    }

    @Override
    public void setLastAttackSuccess(boolean setter) {
        if (setter) {
            EpicFightNetworkManager.sendToPlayer(new SPModifyPlayerData(((ServerPlayer)this.original).m_19879_(), true), (ServerPlayer)this.original);
        }
        this.isLastAttackSuccess = setter;
    }

    public void setAttackTarget(LivingEntity entity) {
        SetTargetEvent setTargetEvent = new SetTargetEvent(this, entity);
        this.getEventListener().triggerEvents(PlayerEventListener.EventType.SET_TARGET_EVENT, setTargetEvent);
        this.attackTarget = setTargetEvent.getTarget();
    }

    @Override
    public void startSkillCharging(ChargeableSkill chargingSkill) {
        super.startSkillCharging(chargingSkill);
        EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.chargingBegin(this.getSkill((Skill)((Object)chargingSkill)).getSlotId()), (ServerPlayer)this.getOriginal());
    }

    @Override
    public LivingEntity getTarget() {
        return this.attackTarget;
    }

    @Override
    public void setGrapplingTarget(LivingEntity grapplingTarget) {
        super.setGrapplingTarget(grapplingTarget);
        EpicFightNetworkManager.sendToPlayer(new SPModifyPlayerData(((ServerPlayer)this.original).m_19879_(), (Entity)grapplingTarget), (ServerPlayer)this.original);
    }
}

